/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.ChangelogEntry;
import com.artipie.rpm.meta.XmlFile;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlPackagesFile;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public final class XmlOthers
implements Closeable {
    private final XmlFile xml;
    private final XmlPackagesFile packages;

    public XmlOthers(Path file) {
        this(new XmlFile(file));
    }

    private XmlOthers(XmlFile xml) {
        this.xml = xml;
        this.packages = new XmlPackagesFile(xml, XmlPackage.OTHER);
    }

    public XmlOthers startPackages() throws XMLStreamException {
        this.packages.startPackages();
        return this;
    }

    public Package addPackage(String name, String arch, String checksum) throws XMLStreamException {
        this.xml.writeStartElement("package");
        this.xml.writeAttribute("pkgid", checksum);
        this.xml.writeAttribute("name", name);
        this.xml.writeAttribute("arch", arch);
        return new Package(this, this.xml);
    }

    @Override
    public void close() throws IOException {
        this.packages.close();
    }

    public static final class Package {
        private final XmlOthers others;
        private final XmlFile xml;

        Package(XmlOthers others, XmlFile xml) {
            this.others = others;
            this.xml = xml;
        }

        public Package version(int eopch, String ver, String rel) throws XMLStreamException {
            this.xml.writeEmptyElement("version");
            this.xml.writeAttribute("epoch", String.valueOf(eopch));
            this.xml.writeAttribute("ver", ver);
            this.xml.writeAttribute("rel", rel);
            return this;
        }

        public Package changelog(List<String> changelogs) throws XMLStreamException {
            for (String changelog : changelogs) {
                ChangelogEntry entry = new ChangelogEntry(changelog);
                this.changelog(entry.author(), entry.date(), entry.content());
            }
            return this;
        }

        public Package changelog(String author, int date, String content) throws XMLStreamException {
            this.xml.writeStartElement("changelog");
            this.xml.writeAttribute("date", String.valueOf(date));
            this.xml.writeAttribute("author", String.valueOf(author));
            this.xml.writeCharacters(content);
            this.xml.writeEndElement();
            return this;
        }

        public XmlOthers close() throws XMLStreamException {
            this.xml.writeEndElement();
            return this.others;
        }
    }
}

