/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.misc;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class StorageLock {
    private static final String FNAME = "lock-%s";
    private static final String PTRN = "%s/lock-[a-z0-9-]{36}";
    private static final String ERROR = "Repository %s is already being updated, %d locks found.";
    private final Storage storage;
    private final Key repo;
    private final Key file;

    public StorageLock(Storage storage, Key repo) {
        this.storage = storage;
        this.repo = repo;
        this.file = new Key.From(this.repo, new String[]{String.format(FNAME, UUID.randomUUID().toString())});
    }

    public CompletableFuture<Void> lock() {
        return this.countLocks().thenCompose(count -> {
            if (count == 0L) {
                return this.storage.save(this.file, (Content)new Content.From(new byte[0])).thenCompose(ignored -> this.countLocks().thenCompose(cnt -> {
                    CompletionStage<Object> res = cnt > 1L ? this.release().thenApply(nothing -> {
                        throw new IllegalStateException(String.format(ERROR, this.repo.string(), cnt));
                    }) : CompletableFuture.completedFuture(null);
                    return res;
                }));
            }
            throw new IllegalStateException(String.format(ERROR, this.repo.string(), count));
        });
    }

    public CompletableFuture<Void> release() {
        return this.storage.delete(this.file);
    }

    private CompletableFuture<Long> countLocks() {
        return this.storage.list(this.repo).thenApply(keys -> keys.stream().filter(key -> key.string().matches(String.format(PTRN, this.repo.string()))).count());
    }
}

