/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.files.Gzip;
import com.artipie.rpm.meta.XmlPackage;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;

public interface PrecedingMetadata {
    public boolean exists() throws IOException;

    public Optional<Path> findAndUnzip() throws IOException;

    public static final class FromDir
    implements PrecedingMetadata {
        private final XmlPackage type;
        private final Path dir;

        public FromDir(XmlPackage type, Path dir) {
            this.type = type;
            this.dir = dir;
        }

        @Override
        public boolean exists() throws IOException {
            return this.find().isPresent();
        }

        @Override
        public Optional<Path> findAndUnzip() throws IOException {
            Optional<Path> res;
            Optional<Path> metadata = this.find();
            if (metadata.isPresent()) {
                Path unziped = Files.createTempFile(this.dir, String.format("old-%s", this.type.filename()), ".xml", new FileAttribute[0]);
                new Gzip(metadata.get()).unpack(unziped);
                res = Optional.of(unziped);
            } else {
                res = Optional.empty();
            }
            return res;
        }

        private Optional<Path> find() throws IOException {
            try (Stream<Path> files = Files.walk(this.dir, new FileVisitOption[0]);){
                Optional<Path> optional = files.filter(path -> path.getFileName().toString().contains(String.format("%s.xml.gz", this.type.filename()))).findFirst();
                return optional;
            }
        }
    }
}

