/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.meta.XmlMaid;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlPrimary;
import com.artipie.rpm.meta.XmlPrimaryMaid;
import com.artipie.rpm.pkg.HeaderTags;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.xml.stream.XMLStreamException;

public final class PrimaryOutput
implements PackageOutput.FileOutput {
    private final Path path;
    private final Path tmp;
    private final XmlPrimary xml;

    public PrimaryOutput(Path file) {
        this.path = file;
        this.tmp = file.getParent().resolve(String.format("%s.part", file.getFileName().toString()));
        this.xml = new XmlPrimary(this.tmp);
    }

    @Override
    public PrimaryOutput start() throws IOException {
        try {
            this.xml.startPackages();
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to start packages", err);
        }
        return this;
    }

    @Override
    public void accept(Package.Meta meta) throws IOException {
        HeaderTags tags = new HeaderTags(meta);
        try {
            this.xml.startPackage().name(tags.name()).arch(tags.arch()).version(tags.epoch(), tags.version(), tags.release()).checksum(meta.checksum().digest().type(), "YES", meta.checksum().hex()).summary(tags.summary()).description(tags.description()).packager(tags.packager()).url(tags.url()).time(tags.fileTimes(), tags.buildTime()).size(meta.size(), tags.installedSize(), tags.archiveSize()).location(meta.href()).startFormat().license(tags.license()).vendor(tags.vendor()).group(tags.group()).buildHost(tags.buildHost()).sourceRpm(tags.sourceRmp()).headerRange(meta.range()[0], meta.range()[1]).provides(tags.providesNames(), tags.providesVer()).requires(tags.requires()).close().files(tags.baseNames().toArray(new String[0]), tags.dirNames().toArray(new String[0]), tags.dirIndexes()).close();
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to update XML", err);
        }
    }

    @Override
    public void close() throws IOException {
        this.xml.close();
        Files.move(this.tmp, this.path, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public Path file() {
        return this.path;
    }

    @Override
    public XmlMaid maid() {
        return new XmlPrimaryMaid(this.path);
    }

    @Override
    public String tag() {
        return XmlPackage.PRIMARY.tag();
    }
}

