/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.SubStorage;
import com.artipie.asto.ext.KeyLastPart;
import com.artipie.asto.fs.FileStorage;
import com.artipie.asto.lock.Lock;
import com.artipie.asto.lock.storage.StorageLock;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.rpm.Digest;
import com.artipie.rpm.ModifiableRepository;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.Repository;
import com.artipie.rpm.StandardNamingPolicy;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlPrimaryChecksums;
import com.artipie.rpm.misc.UncheckedFunc;
import com.artipie.rpm.pkg.FilePackage;
import com.artipie.rpm.pkg.InvalidPackageException;
import com.artipie.rpm.pkg.MetadataFile;
import com.artipie.rpm.pkg.ModifiableMetadata;
import com.artipie.rpm.pkg.PrecedingMetadata;
import com.artipie.rpm.pkg.Repodata;
import com.jcabi.log.Logger;
import hu.akarnokd.rxjava2.interop.CompletableInterop;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Rpm {
    private final Storage storage;
    private final RepoConfig config;

    public Rpm(Storage stg) {
        this(stg, StandardNamingPolicy.PLAIN, Digest.SHA256, false);
    }

    public Rpm(Storage stg, boolean filelists) {
        this(stg, StandardNamingPolicy.PLAIN, Digest.SHA256, filelists);
    }

    public Rpm(Storage stg, NamingPolicy naming, Digest dgst, boolean filelists) {
        this(stg, new RepoConfig.Simple(dgst, naming, filelists));
    }

    public Rpm(Storage storage, RepoConfig config) {
        this.storage = storage;
        this.config = config;
    }

    @Deprecated
    public Completable update(String key) {
        return this.update((Key)new Key.From(key));
    }

    @Deprecated
    public Completable update(Key key) {
        String[] parts = key.string().split("/");
        Object folder = parts.length == 1 ? Key.ROOT : new Key.From((String[])Arrays.stream(parts).limit(parts.length - 1).toArray(String[]::new));
        return this.batchUpdate((Key)folder);
    }

    @Deprecated
    public Completable batchUpdate(String prefix) {
        return this.batchUpdate((Key)new Key.From(prefix));
    }

    public Completable batchUpdate(Key prefix) {
        Path metadir;
        Path tmpdir;
        try {
            tmpdir = Files.createTempDirectory("repo-", new FileAttribute[0]);
            metadir = Files.createTempDirectory("meta-", new FileAttribute[0]);
        }
        catch (IOException err) {
            throw new IllegalStateException("Failed to create temp dir", err);
        }
        FileStorage local = new FileStorage(tmpdir);
        return this.doWithLock(prefix, () -> this.lambda$batchUpdate$9(prefix, tmpdir, (Storage)local, metadir));
    }

    public Completable batchUpdateIncrementally(Key prefix) {
        Path metadir;
        Path tmpdir;
        try {
            tmpdir = Files.createTempDirectory("repo-", new FileAttribute[0]);
            metadir = Files.createTempDirectory("meta-", new FileAttribute[0]);
        }
        catch (IOException err) {
            throw new IllegalStateException("Failed to create temp dir", err);
        }
        FileStorage local = new FileStorage(tmpdir);
        return this.doWithLock(prefix, () -> this.lambda$batchUpdateIncrementally$24(prefix, (Storage)local, tmpdir, metadir));
    }

    private Completable removeOldMetadata(Set<String> preserve, Key prefix) {
        return new RxStorageWrapper(this.storage).list((Key)new Key.From(prefix, new String[]{"repodata"})).flatMapObservable(Observable::fromIterable).filter(item -> !preserve.contains(Paths.get(item.string(), new String[0]).getFileName().toString())).flatMapCompletable(item -> new RxStorageWrapper(this.storage).delete(item));
    }

    private Single<Path> moveRepodataToStorage(Storage local, Path path, Key prefix) {
        return new RxStorageWrapper(local).value((Key)new Key.From(path.getFileName().toString())).flatMapCompletable(content -> new RxStorageWrapper((Storage)new SubStorage(prefix, this.storage)).save((Key)new Key.From(new String[]{"repodata", path.getFileName().toString()}), content)).toSingleDefault((Object)path);
    }

    private Flowable<FilePackage> filePackageFromRpm(Key prefix, Path tmpdir, Storage local) {
        return SingleInterop.fromFuture((CompletionStage)this.storage.list(prefix)).flatMapPublisher(Flowable::fromIterable).filter(key -> key.string().endsWith(".rpm")).flatMapSingle(key -> {
            String file = new KeyLastPart(key).get();
            return new RxStorageWrapper(this.storage).value(key).flatMapCompletable(content -> new RxStorageWrapper(local).save((Key)new Key.From(file), content)).andThen((SingleSource)Single.fromCallable(() -> new FilePackage(tmpdir.resolve(file))));
        });
    }

    private static void cleanup(Path dir) throws IOException {
        for (Path item : Files.list(dir).collect(Collectors.toList())) {
            Files.delete(item);
        }
        Files.delete(dir);
    }

    private Repository repository() {
        return new Repository(new XmlPackage.Stream(this.config.filelists()).get().map(new UncheckedFunc(item -> new MetadataFile((XmlPackage)((Object)item), item.output().start()))).collect(Collectors.toList()), this.config.digest());
    }

    private ModifiableRepository mdfRepository(Path dir) throws IOException {
        return new ModifiableRepository(new PrecedingMetadata.FromDir(XmlPackage.PRIMARY, dir).findAndUnzip().map(new UncheckedFunc(file -> new XmlPrimaryChecksums((Path)file).read())).orElse(Collections.emptyList()), new XmlPackage.Stream(this.config.filelists()).get().map(new UncheckedFunc(item -> new ModifiableMetadata(new MetadataFile((XmlPackage)((Object)item), item.output().start()), new PrecedingMetadata.FromDir((XmlPackage)((Object)item), dir)))).collect(Collectors.toList()), this.config.digest());
    }

    private Completable doWithLock(Key target, Supplier<Completable> operation) {
        StorageLock lock = new StorageLock(this.storage, target, Instant.now().plus(Duration.ofHours(1L)));
        return Completable.fromFuture(lock.acquire().thenCompose(nothing -> (CompletionStage)((Completable)operation.get()).to(CompletableInterop.await())).thenCompose(arg_0 -> Rpm.lambda$doWithLock$36((Lock)lock, arg_0)).toCompletableFuture());
    }

    private static /* synthetic */ CompletionStage lambda$doWithLock$36(Lock lock, Object nothing) {
        return lock.release();
    }

    private /* synthetic */ Completable lambda$batchUpdateIncrementally$24(Key prefix, Storage local, Path tmpdir, Path metadir) {
        return SingleInterop.fromFuture((CompletionStage)this.storage.list(prefix)).flatMapPublisher(Flowable::fromIterable).filter(key -> key.string().endsWith("xml.gz")).flatMapCompletable(key -> new RxStorageWrapper(this.storage).value(key).flatMapCompletable(content -> new RxStorageWrapper(local).save((Key)new Key.From(new KeyLastPart(key).get()), content))).andThen((SingleSource)Single.fromCallable(() -> this.mdfRepository(tmpdir))).flatMap(repo -> this.filePackageFromRpm(prefix, tmpdir, local).parallel().runOn(Schedulers.io()).sequential().observeOn(Schedulers.io()).reduce(repo, (ignored, pkg) -> repo.update((FilePackage)pkg))).doOnSuccess(rep -> Logger.info((Object)this, (String)"repository updated")).doOnSuccess(ModifiableRepository::close).doOnSuccess(rep -> Logger.info((Object)this, (String)"repository closed")).doOnSuccess(ModifiableRepository::clear).doOnSuccess(rep -> Logger.info((Object)this, (String)"repository cleared")).flatMapObservable(rep -> Observable.fromIterable(rep.save(new Repodata.Temp(this.config.naming(), metadir)))).flatMapSingle(path -> this.moveRepodataToStorage((Storage)new FileStorage(metadir), (Path)path, prefix)).map(path -> path.getFileName().toString()).toList().map(HashSet::new).flatMapCompletable(preserve -> this.removeOldMetadata((Set<String>)preserve, prefix)).doOnTerminate(() -> Rpm.cleanup(tmpdir));
    }

    private /* synthetic */ Completable lambda$batchUpdate$9(Key prefix, Path tmpdir, Storage local, Path metadir) {
        return this.filePackageFromRpm(prefix, tmpdir, local).parallel().runOn(Schedulers.io()).flatMap(file -> {
            Flowable parsed;
            try {
                parsed = Flowable.just((Object)file.parsed());
            }
            catch (InvalidPackageException ex) {
                Logger.warn((Object)this, (String)"Failed parsing '%s': %[exception]s", (Object[])new Object[]{file.path(), ex});
                parsed = Flowable.empty();
            }
            return parsed;
        }).sequential().observeOn(Schedulers.io()).reduceWith(this::repository, Repository::update).doOnSuccess(rep -> Logger.info((Object)this, (String)"repository updated")).doOnSuccess(Repository::close).doOnSuccess(rep -> Logger.info((Object)this, (String)"repository closed")).flatMapObservable(rep -> Observable.fromIterable(rep.save(new Repodata.Temp(this.config.naming(), metadir)))).flatMapSingle(path -> this.moveRepodataToStorage((Storage)new FileStorage(metadir), (Path)path, prefix)).map(path -> path.getFileName().toString()).toList().map(HashSet::new).flatMapCompletable(preserve -> this.removeOldMetadata((Set<String>)preserve, prefix)).doOnTerminate(() -> {
            Rpm.cleanup(tmpdir);
            Rpm.cleanup(metadir);
        });
    }
}

