/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.google.common.primitives.Ints;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ChangelogEntry {
    private static final Pattern PATTERN = Pattern.compile("\\* (?<date>\\w+ \\w+ \\d+ \\d+) (?<author>[^-]+) (?<content>-.*)", 32);
    private final String origin;

    ChangelogEntry(String origin) {
        this.origin = origin;
    }

    String author() {
        return this.matcher().group("author");
    }

    int date() {
        Date date;
        String str = this.matcher().group("date");
        SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd yyyy", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            date = format.parse(str);
        }
        catch (ParseException ex) {
            throw new IllegalStateException(String.format("Failed to parse date: '%s'", str), ex);
        }
        return Ints.checkedCast((long)TimeUnit.MILLISECONDS.toSeconds(date.getTime()));
    }

    String content() {
        return this.matcher().group("content");
    }

    private Matcher matcher() {
        Matcher matcher = PATTERN.matcher(this.origin);
        if (!matcher.matches()) {
            throw new IllegalStateException(String.format("Cannot parse: '%s'", this.origin));
        }
        return matcher;
    }
}

