/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.pkg.FilelistsOutput;
import com.artipie.rpm.pkg.OthersOutput;
import com.artipie.rpm.pkg.PackageOutput;
import com.artipie.rpm.pkg.PrimaryOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapOf;

public enum XmlPackage {
    PRIMARY("metadata", (Map)new MapOf(new Map.Entry[]{new MapEntry((Object)"", (Object)"http://linux.duke.edu/metadata/common"), new MapEntry((Object)"rpm", (Object)"http://linux.duke.edu/metadata/rpm")})){

        @Override
        public PackageOutput.FileOutput output() throws IOException {
            return new PrimaryOutput(Files.createTempFile(this.tempPrefix(), XmlPackage.SUFFIX, new FileAttribute[0]));
        }
    }
    ,
    OTHER("otherdata", (Map)new MapOf(new Map.Entry[]{new MapEntry((Object)"", (Object)"http://linux.duke.edu/metadata/other")})){

        @Override
        public PackageOutput.FileOutput output() throws IOException {
            return new OthersOutput(Files.createTempFile(this.tempPrefix(), XmlPackage.SUFFIX, new FileAttribute[0]));
        }
    }
    ,
    FILELISTS("filelists", (Map)new MapOf(new Map.Entry[]{new MapEntry((Object)"", (Object)"http://linux.duke.edu/metadata/filelists")})){

        @Override
        public PackageOutput.FileOutput output() throws IOException {
            return new FilelistsOutput(Files.createTempFile(this.tempPrefix(), XmlPackage.SUFFIX, new FileAttribute[0]));
        }
    };

    private static final String SUFFIX = ".xml";
    private final String tagname;
    private final Map<String, String> namespaces;

    private XmlPackage(String tagname, Map<String, String> namespaces) {
        this.tagname = tagname;
        this.namespaces = namespaces;
    }

    public String tag() {
        return this.tagname;
    }

    public String filename() {
        return this.name().toLowerCase(Locale.getDefault());
    }

    public String tempPrefix() {
        return String.format("%s-", this.filename());
    }

    public Map<String, String> xmlNamespaces() {
        return this.namespaces;
    }

    public abstract PackageOutput.FileOutput output() throws IOException;

    public static final class Stream {
        private final boolean filelists;

        public Stream(boolean filelists) {
            this.filelists = filelists;
        }

        public java.util.stream.Stream<XmlPackage> get() {
            java.util.stream.Stream<XmlPackage> res = this.filelists ? java.util.stream.Stream.of(XmlPackage.values()) : java.util.stream.Stream.of(PRIMARY, OTHER);
            return res;
        }
    }
}

