/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.asto.ArtipieIOException;
import com.artipie.rpm.Digest;
import com.artipie.rpm.meta.MergedXml;
import com.artipie.rpm.meta.MergedXmlPackage;
import com.artipie.rpm.meta.MergedXmlPrimary;
import com.artipie.rpm.meta.XmlAlter;
import com.artipie.rpm.meta.XmlEvent;
import com.artipie.rpm.meta.XmlEventPrimary;
import com.artipie.rpm.meta.XmlMaid;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlPrimaryMaid;
import com.artipie.rpm.pkg.Checksum;
import com.artipie.rpm.pkg.FilePackage;
import com.artipie.rpm.pkg.Package;
import com.jcabi.log.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Header;

public interface RpmMetadata {

    public static final class RpmItem
    implements Package.Meta {
        private final Header header;
        private final long size;
        private final Checksum sum;
        private final String location;

        public RpmItem(Header header, long size, Checksum sum, String location) {
            this.header = header;
            this.size = size;
            this.sum = sum;
            this.location = location;
        }

        public RpmItem(Header header, long size, String dgst, String location) {
            this(header, size, new Checksum.Simple(Digest.SHA256, dgst), location);
        }

        @Override
        public Package.MetaHeader header(Header.HeaderTag tag) {
            return new FilePackage.EntryHeader(this.header.getEntry((AbstractHeader.Tag)tag));
        }

        @Override
        public Checksum checksum() {
            return this.sum;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public String href() {
            return this.location;
        }

        @Override
        public int[] range() {
            return new int[]{this.header.getStartPos(), this.header.getEndPos()};
        }
    }

    public static final class MetadataItem {
        private final XmlPackage type;
        private final Optional<InputStream> input;
        private final OutputStream out;

        public MetadataItem(XmlPackage type, Optional<InputStream> input, OutputStream out) {
            this.type = type;
            this.input = input;
            this.out = out;
        }

        public MetadataItem(XmlPackage type, InputStream input, OutputStream out) {
            this(type, Optional.of(input), out);
        }

        public MetadataItem(XmlPackage type, OutputStream out) {
            this(type, Optional.empty(), out);
        }
    }

    public static final class Append {
        private final Collection<MetadataItem> items;

        public Append(MetadataItem ... items) {
            this.items = Arrays.asList(items);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Collection<Package.Meta> packages) {
            try {
                Path temp = Files.createTempFile("rpm-primary-append", ".xml", new FileAttribute[0]);
                try {
                    MergedXml.Result res;
                    MetadataItem primary = this.items.stream().filter(item -> ((MetadataItem)item).type == XmlPackage.PRIMARY).findFirst().get();
                    try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(temp, new OpenOption[0]));){
                        res = new MergedXmlPrimary(primary.input, (OutputStream)out).merge(packages, new XmlEventPrimary());
                    }
                    ExecutorService service = Executors.newFixedThreadPool(3);
                    service.submit(Append.setPrimaryPckg(temp, res, primary));
                    service.submit(this.updateOther(packages, res));
                    service.submit(this.updateFilelist(packages, res));
                    service.shutdown();
                    service.awaitTermination(Long.MAX_VALUE, TimeUnit.HOURS);
                }
                catch (InterruptedException err) {
                    Thread.currentThread().interrupt();
                    Logger.error((Object)this, (String)err.getMessage());
                }
                finally {
                    Files.delete(temp);
                }
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }

        private Runnable updateFilelist(Collection<Package.Meta> packages, MergedXml.Result res) {
            return () -> {
                Optional<MetadataItem> filelist = this.items.stream().filter(item -> ((MetadataItem)item).type == XmlPackage.FILELISTS).findFirst();
                if (filelist.isPresent()) {
                    try {
                        new MergedXmlPackage(filelist.get().input, filelist.get().out, XmlPackage.FILELISTS, res).merge(packages, new XmlEvent.Filelists());
                    }
                    catch (IOException err) {
                        throw new ArtipieIOException(err);
                    }
                }
            };
        }

        private Runnable updateOther(Collection<Package.Meta> packages, MergedXml.Result res) {
            return () -> {
                try {
                    MetadataItem other = this.items.stream().filter(item -> ((MetadataItem)item).type == XmlPackage.OTHER).findFirst().get();
                    new MergedXmlPackage(other.input, other.out, XmlPackage.OTHER, res).merge(packages, new XmlEvent.Other());
                }
                catch (IOException err) {
                    throw new ArtipieIOException(err);
                }
            };
        }

        private static Runnable setPrimaryPckg(Path temp, MergedXml.Result res, MetadataItem primary) {
            return () -> {
                try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(temp, new OpenOption[0]));){
                    new XmlAlter.Stream(input, primary.out).pkgAttr(primary.type.tag(), String.valueOf(res.count()));
                }
                catch (IOException err) {
                    throw new ArtipieIOException(err);
                }
            };
        }
    }

    public static final class Remove {
        private static final String SUFFIX = ".xml";
        private final Collection<MetadataItem> items;

        public Remove(MetadataItem ... items) {
            this.items = Arrays.asList(items);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Collection<String> checksums) {
            try {
                for (MetadataItem item : this.items) {
                    if (!item.input.isPresent()) continue;
                    Path temp = Files.createTempFile("rpm-index", SUFFIX, new FileAttribute[0]);
                    try {
                        long res;
                        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(temp, new OpenOption[0]));){
                            XmlMaid maid = item.type == XmlPackage.PRIMARY ? new XmlPrimaryMaid.Stream((InputStream)item.input.get(), out) : new XmlMaid.ByPkgidAttr.Stream((InputStream)item.input.get(), out);
                            res = maid.clean(checksums);
                        }
                        BufferedInputStream input = new BufferedInputStream(Files.newInputStream(temp, new OpenOption[0]));
                        var9_9 = null;
                        try {
                            new XmlAlter.Stream(input, item.out).pkgAttr(item.type.tag(), String.valueOf(res));
                        }
                        catch (Throwable throwable) {
                            var9_9 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (input == null) continue;
                            if (var9_9 != null) {
                                try {
                                    ((InputStream)input).close();
                                }
                                catch (Throwable throwable) {
                                    var9_9.addSuppressed(throwable);
                                }
                                continue;
                            }
                            ((InputStream)input).close();
                        }
                    }
                    finally {
                        Files.delete(temp);
                    }
                }
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        }
    }
}

