/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.asto.misc.UncheckedScalar;
import com.artipie.asto.streams.StorageValuePipeline;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.asto.AstoArchive;
import com.artipie.rpm.asto.AstoChecksumAndSize;
import com.artipie.rpm.meta.MergedXml;
import com.artipie.rpm.meta.MergedXmlPackage;
import com.artipie.rpm.meta.MergedXmlPrimary;
import com.artipie.rpm.meta.XmlAlter;
import com.artipie.rpm.meta.XmlEvent;
import com.artipie.rpm.meta.XmlEventPrimary;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.pkg.Package;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.zip.GZIPInputStream;

public final class AstoMetadataAdd {
    private final Storage asto;
    private final RepoConfig cnfg;

    public AstoMetadataAdd(Storage asto, RepoConfig cnfg) {
        this.asto = asto;
        this.cnfg = cnfg;
    }

    public CompletionStage<Key> perform(Collection<Package.Meta> metas) {
        Key.From prefix = new Key.From(UUID.randomUUID().toString());
        return this.addToPrimary((Key)prefix, metas).thenCompose(arg_0 -> this.lambda$perform$0((Key)prefix, metas, arg_0)).thenCompose(arg_0 -> this.lambda$perform$5((Key)prefix, arg_0)).thenApply(arg_0 -> AstoMetadataAdd.lambda$perform$6((Key)prefix, arg_0));
    }

    private CompletionStage<MergedXml.Result> addToPrimary(Key temp, Collection<Package.Meta> metas) {
        return this.getExistingOrDefaultKey(XmlPackage.PRIMARY).thenCompose(key -> {
            Key.From tempkey = new Key.From(temp, new String[]{XmlPackage.PRIMARY.name()});
            return new StorageValuePipeline(this.asto, key, (Key)tempkey).processWithResult((input, out) -> (MergedXml.Result)new UncheckedScalar(() -> new MergedXmlPrimary(input.map(new UncheckedIOFunc(GZIPInputStream::new)), (OutputStream)out).merge(metas, new XmlEventPrimary())).value()).thenApply(res -> res).thenCompose(arg_0 -> this.lambda$null$12((Key)tempkey, arg_0)).thenApply(res -> res);
        });
    }

    private CompletableFuture<Void> add(Key temp, Collection<Package.Meta> metas, MergedXml.Result primary, XmlPackage type, XmlEvent event) {
        return this.getExistingOrDefaultKey(type).thenCompose(key -> {
            Key.From tempkey = new Key.From(temp, new String[]{type.name()});
            return new StorageValuePipeline(this.asto, key, (Key)tempkey).process((input, out) -> {
                MergedXml.Result cfr_ignored_0 = (MergedXml.Result)new UncheckedScalar(() -> new MergedXmlPackage(input.map(new UncheckedIOFunc(GZIPInputStream::new)), (OutputStream)out, type, primary).merge(metas, event)).value();
            });
        }).toCompletableFuture();
    }

    private CompletionStage<Key> getExistingOrDefaultKey(XmlPackage type) {
        String key = String.format("%s.xml.gz", type.lowercase());
        return this.asto.list((Key)new Key.From("repodata")).thenApply(list -> list.stream().filter(item -> item.string().endsWith(key)).findFirst().orElse((Key)new Key.From(key)));
    }

    private /* synthetic */ CompletionStage lambda$null$12(Key tempkey, MergedXml.Result res) {
        return new StorageValuePipeline(this.asto, tempkey).process((input, out) -> new XmlAlter.Stream(new BufferedInputStream((InputStream)input.get()), new BufferedOutputStream((OutputStream)out)).pkgAttr(XmlPackage.PRIMARY.tag(), String.valueOf(res.count()))).thenApply(nothing -> res);
    }

    private static /* synthetic */ Key lambda$perform$6(Key prefix, Void nothing) {
        return prefix;
    }

    private /* synthetic */ CompletionStage lambda$perform$5(Key prefix, Void ignored) {
        return this.asto.list(prefix).thenCompose(list -> CompletableFuture.allOf((CompletableFuture[])list.stream().map(item -> new AstoChecksumAndSize(this.asto, this.cnfg.digest()).calculate((Key)item).thenCompose(nothing -> new AstoArchive(this.asto).gzip((Key)item))).toArray(CompletableFuture[]::new)));
    }

    private /* synthetic */ CompletionStage lambda$perform$0(Key prefix, Collection metas, MergedXml.Result res) {
        CompletableFuture<Void> future = this.cnfg.filelists() ? CompletableFuture.allOf(this.add(prefix, metas, res, XmlPackage.OTHER, new XmlEvent.Other()), this.add(prefix, metas, res, XmlPackage.FILELISTS, new XmlEvent.Filelists())) : this.add(prefix, metas, res, XmlPackage.OTHER, new XmlEvent.Other());
        return future;
    }
}

