/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.asto.misc.UncheckedIOScalar;
import com.artipie.asto.streams.StorageValuePipeline;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.asto.AstoArchive;
import com.artipie.rpm.asto.AstoChecksumAndSize;
import com.artipie.rpm.meta.XmlAlter;
import com.artipie.rpm.meta.XmlMaid;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlPrimaryMaid;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public final class AstoMetadataRemove {
    private final Storage asto;
    private final RepoConfig cnfg;

    public AstoMetadataRemove(Storage asto, RepoConfig cnfg) {
        this.asto = asto;
        this.cnfg = cnfg;
    }

    public CompletionStage<Key> perform(Collection<String> checksums) {
        ArrayList<CompletionStage> res = new ArrayList<CompletionStage>(3);
        Key.From prefix = new Key.From(UUID.randomUUID().toString());
        for (XmlPackage pckg : new XmlPackage.Stream(this.cnfg.filelists()).get().collect(Collectors.toList())) {
            res.add(CompletableFuture.supplyAsync(() -> pckg).thenCompose(pkg -> ((CompletableFuture)this.asto.list((Key)new Key.From("repodata")).thenApply(list -> list.stream().filter(item -> item.string().contains(pckg.lowercase())).findFirst())).thenCompose(opt -> {
                Key.From tmpkey = new Key.From((Key)prefix, new String[]{pkg.name()});
                CompletionStage<Void> result = CompletableFuture.allOf(new CompletableFuture[0]);
                if (opt.isPresent()) {
                    result = this.removePackages(pckg, (Key)opt.get(), (Key)tmpkey, checksums).thenCompose(arg_0 -> this.lambda$null$4((Key)tmpkey, pckg, arg_0)).thenCompose(arg_0 -> this.lambda$null$5((Key)tmpkey, arg_0)).thenCompose(arg_0 -> this.lambda$null$6((Key)tmpkey, arg_0));
                }
                return result;
            })));
        }
        return CompletableFuture.allOf(res.toArray(new CompletableFuture[0])).thenApply(nothing -> prefix);
    }

    private CompletionStage<Long> removePackages(XmlPackage pckg, Key key, Key temp, Collection<String> checksums) {
        return new StorageValuePipeline(this.asto, key, temp).processWithResult((opt, out) -> {
            InputStream input = (InputStream)opt.map(new UncheckedIOFunc(GZIPInputStream::new)).get();
            XmlMaid maid = pckg == XmlPackage.PRIMARY ? new XmlPrimaryMaid.Stream(input, (OutputStream)out) : new XmlMaid.ByPkgidAttr.Stream(input, (OutputStream)out);
            return (Long)new UncheckedIOScalar(() -> maid.clean(checksums)).value();
        });
    }

    private /* synthetic */ CompletionStage lambda$null$6(Key tmpkey, Void hex) {
        return new AstoArchive(this.asto).gzip(tmpkey);
    }

    private /* synthetic */ CompletionStage lambda$null$5(Key tmpkey, Void nothing) {
        return new AstoChecksumAndSize(this.asto, this.cnfg.digest()).calculate(tmpkey);
    }

    private /* synthetic */ CompletionStage lambda$null$4(Key tmpkey, XmlPackage pckg, Long cnt) {
        return new StorageValuePipeline(this.asto, tmpkey).process((inpt, out) -> new XmlAlter.Stream(new BufferedInputStream((InputStream)inpt.get()), new BufferedOutputStream((OutputStream)out)).pkgAttr(pckg.tag(), String.valueOf(cnt)));
    }
}

