/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.key.KeyExcludeFirst;
import com.artipie.asto.lock.storage.StorageLock;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.asto.AstoCreateRepomd;
import com.artipie.rpm.asto.AstoMetadataAdd;
import com.artipie.rpm.asto.AstoMetadataNames;
import com.artipie.rpm.asto.AstoRpmPackage;
import com.artipie.rpm.http.RpmUpload;
import com.artipie.rpm.pkg.Package;
import com.jcabi.log.Logger;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public final class AstoRepoAdd {
    private static final Key META = new Key.From("repodata");
    private final Storage asto;
    private final RepoConfig cnfg;

    public AstoRepoAdd(Storage asto, RepoConfig cnfg) {
        this.asto = asto;
        this.cnfg = cnfg;
    }

    public CompletionStage<Void> perform() {
        return this.read().thenCompose(list -> new AstoMetadataAdd(this.asto, this.cnfg).perform((Collection<Package.Meta>)list)).thenCompose(temp -> new AstoCreateRepomd(this.asto, this.cnfg).perform((Key)temp).thenCompose(nothing -> new AstoMetadataNames(this.asto, this.cnfg).prepareNames((Key)temp).thenCompose(keys -> {
            StorageLock lock = new StorageLock(this.asto, META);
            return lock.acquire().thenCompose(ignored -> this.remove(META)).thenCompose(ignored -> CompletableFuture.allOf((CompletableFuture[])keys.entrySet().stream().map(entry -> this.asto.move((Key)entry.getKey(), (Key)entry.getValue())).toArray(CompletableFuture[]::new))).thenCompose(ignored -> this.asto.list(RpmUpload.TO_ADD).thenCompose(list -> CompletableFuture.allOf((CompletableFuture[])list.stream().map(key -> this.asto.move(key, AstoRepoAdd.removeTempPart(key))).toArray(CompletableFuture[]::new)))).thenCompose(ignored -> lock.release()).thenCompose(ignored -> this.remove((Key)temp));
        })));
    }

    private CompletionStage<List<Package.Meta>> read() {
        return (CompletionStage)SingleInterop.fromFuture((CompletionStage)this.asto.list(RpmUpload.TO_ADD)).flatMapPublisher(Flowable::fromIterable).parallel().runOn(Schedulers.io()).flatMap(key -> Flowable.fromFuture(new AstoRpmPackage(this.asto, this.cnfg.digest()).packageMeta((Key)key, AstoRepoAdd.removeTempPart(key).string()).toCompletableFuture()).onErrorResumeNext(throwable -> {
            Logger.warn((Object)this, (String)"Failed to parse rpm package %s\n%s", (Object[])new Object[]{key.string(), throwable.getMessage()});
            return new RxStorageWrapper(this.asto).delete(key).andThen((Publisher)Flowable.empty());
        })).sequential().observeOn(Schedulers.io()).toList().to(SingleInterop.get());
    }

    private CompletableFuture<Void> remove(Key key) {
        return this.asto.list(key).thenCompose(list -> CompletableFuture.allOf((CompletableFuture[])list.stream().map(arg_0 -> ((Storage)this.asto).delete(arg_0)).toArray(CompletableFuture[]::new)));
    }

    private static Key removeTempPart(Key key) {
        return new KeyExcludeFirst(key, RpmUpload.TO_ADD.string());
    }
}

