/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.pkg.HeaderTags;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ComparableVersion;

public final class RpmDependency {
    private final String name;
    private final HeaderTags.Version vers;
    private final Optional<String> flag;

    public RpmDependency(String name, HeaderTags.Version vers, Optional<String> flag) {
        this.name = name;
        this.vers = vers;
        this.flag = flag;
    }

    public boolean isSatisfiedBy(String aname, HeaderTags.Version avers) {
        boolean res = false;
        if (this.name.concat(this.vers.toString()).equals(aname.concat(avers.toString()))) {
            res = true;
        } else if ((this.vers.toString().isEmpty() || avers.toString().isEmpty()) && this.name.equals(aname)) {
            res = true;
        } else if (this.name.equals(aname) && this.flag.isPresent() && !this.flag.get().equals(HeaderTags.Flags.EQUAL.notation())) {
            res = this.flag.get().equals(HeaderTags.Flags.LESS_OR_EQUAL.notation()) && avers.compareTo(this.vers) <= 0 || this.flag.get().equals(HeaderTags.Flags.LESS.notation()) && avers.compareTo(this.vers) < 0 || this.flag.get().equals(HeaderTags.Flags.GREATER_OR_EQUAL.notation()) && avers.compareTo(this.vers) >= 0 || this.flag.get().equals(HeaderTags.Flags.GREATER.notation()) && avers.compareTo(this.vers) > 0;
        } else if (this.name.equals(aname) && this.flag.isPresent() && this.flag.get().equals(HeaderTags.Flags.EQUAL.notation()) && (!this.vers.rel().isPresent() || !avers.rel().isPresent())) {
            res = new ComparableVersion(this.vers.ver()).compareTo(new ComparableVersion(avers.ver())) == 0;
        }
        return res;
    }
}

