/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.ChangelogEntry;
import com.artipie.rpm.pkg.HeaderTags;
import com.artipie.rpm.pkg.Package;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public interface XmlEvent {
    public void add(XMLEventWriter var1, Package.Meta var2) throws IOException;

    public static final class Files
    implements XmlEvent {
        private static final int S_IFMT = 61440;
        private static final int S_IFDIR = 16384;
        private final Predicate<String> filter;

        public Files(Predicate<String> filter) {
            this.filter = filter;
        }

        public Files() {
            this(name -> false);
        }

        @Override
        public void add(XMLEventWriter writer, Package.Meta meta) throws IOException {
            XMLEventFactory events = XMLEventFactory.newFactory();
            HeaderTags tags = new HeaderTags(meta);
            try {
                String[] files = tags.baseNames().toArray(new String[0]);
                String[] dirs = tags.dirNames().toArray(new String[0]);
                int[] did = tags.dirIndexes();
                int[] fmod = tags.fileModes();
                int[] flags = tags.fileFlags();
                for (int idx = 0; idx < files.length; ++idx) {
                    String path;
                    String fle = files[idx];
                    if (fle.isEmpty() || fle.charAt(0) == '.' || this.filter.test(path = String.format("%s%s", dirs[did[idx]], fle))) continue;
                    writer.add(events.createStartElement("", "", "file"));
                    if ((fmod[idx] & 0xF000) == 16384) {
                        writer.add(events.createAttribute("type", "dir"));
                    } else if ((flags[idx] & 0x40) > 0) {
                        writer.add(events.createAttribute("type", "ghost"));
                    }
                    writer.add(events.createCharacters(path));
                    writer.add(events.createEndElement("", "", "file"));
                }
            }
            catch (XMLStreamException err) {
                throw new IOException(err);
            }
        }

        public Set<String> files(HeaderTags tags) {
            String[] files = tags.baseNames().toArray(new String[0]);
            String[] dirs = tags.dirNames().toArray(new String[0]);
            int[] did = tags.dirIndexes();
            HashSet<String> res = new HashSet<String>(files.length);
            for (int idx = 0; idx < files.length; ++idx) {
                String path;
                String fle = files[idx];
                if (fle.isEmpty() || fle.charAt(0) == '.' || this.filter.test(path = String.format("%s%s", dirs[did[idx]], fle))) continue;
                res.add(path);
            }
            return res;
        }
    }

    public static final class Filelists
    implements XmlEvent {
        @Override
        public void add(XMLEventWriter writer, Package.Meta meta) throws IOException {
            XMLEventFactory events = XMLEventFactory.newFactory();
            try {
                new PackageAndVersion().add(writer, meta);
                new Files().add(writer, meta);
                writer.add(events.createEndElement("", "", "package"));
            }
            catch (XMLStreamException err) {
                throw new IOException(err);
            }
        }
    }

    public static final class Other
    implements XmlEvent {
        @Override
        public void add(XMLEventWriter writer, Package.Meta meta) throws IOException {
            XMLEventFactory events = XMLEventFactory.newFactory();
            HeaderTags tags = new HeaderTags(meta);
            try {
                new PackageAndVersion().add(writer, meta);
                for (String changelog : tags.changelog()) {
                    ChangelogEntry entry = new ChangelogEntry(changelog);
                    String tag = "changelog";
                    writer.add(events.createStartElement("", "", "changelog"));
                    writer.add(events.createAttribute("date", String.valueOf(entry.date())));
                    writer.add(events.createAttribute("author", entry.author()));
                    writer.add(events.createCharacters(entry.content()));
                    writer.add(events.createEndElement("", "", "changelog"));
                }
                writer.add(events.createEndElement("", "", "package"));
            }
            catch (XMLStreamException err) {
                throw new IOException(err);
            }
        }
    }

    public static final class PackageAndVersion
    implements XmlEvent {
        @Override
        public void add(XMLEventWriter writer, Package.Meta meta) throws IOException {
            XMLEventFactory events = XMLEventFactory.newFactory();
            HeaderTags tags = new HeaderTags(meta);
            String pkg = "package";
            String version = "version";
            try {
                writer.add(events.createStartElement("", "", "package"));
                writer.add(events.createAttribute("pkgid", meta.checksum().hex()));
                writer.add(events.createAttribute("name", tags.name()));
                writer.add(events.createAttribute("arch", tags.arch()));
                writer.add(events.createStartElement("", "", "version"));
                writer.add(events.createAttribute("epoch", String.valueOf(tags.epoch())));
                writer.add(events.createAttribute("ver", tags.version()));
                writer.add(events.createAttribute("rel", tags.release()));
                writer.add(events.createEndElement("", "", "version"));
            }
            catch (XMLStreamException err) {
                throw new IOException(err);
            }
        }
    }
}

