/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.amihaiemil.eoyaml.Node;
import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import com.artipie.ArtipieException;
import com.artipie.rpm.Digest;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.RpmOptions;
import com.artipie.rpm.StandardNamingPolicy;
import java.util.Locale;
import java.util.Optional;

public interface RepoConfig {
    public Digest digest();

    public NamingPolicy naming();

    public boolean filelists();

    public UpdateMode mode();

    public Optional<String> cron();

    public static final class Simple
    implements RepoConfig {
        private final Digest dgst;
        private final NamingPolicy npolicy;
        private final boolean filelist;
        private final UpdateMode umode;

        public Simple(Digest dgst, NamingPolicy npolicy, boolean filelist, UpdateMode umode) {
            this.dgst = dgst;
            this.npolicy = npolicy;
            this.filelist = filelist;
            this.umode = umode;
        }

        public Simple(Digest dgst, NamingPolicy npolicy, boolean filelist) {
            this(dgst, npolicy, filelist, UpdateMode.UPLOAD);
        }

        public Simple() {
            this(Digest.SHA256, StandardNamingPolicy.PLAIN, false, UpdateMode.UPLOAD);
        }

        public Simple(UpdateMode umode) {
            this(Digest.SHA256, StandardNamingPolicy.PLAIN, false, umode);
        }

        @Override
        public Digest digest() {
            return this.dgst;
        }

        @Override
        public NamingPolicy naming() {
            return this.npolicy;
        }

        @Override
        public boolean filelists() {
            return this.filelist;
        }

        @Override
        public UpdateMode mode() {
            return this.umode;
        }

        @Override
        public Optional<String> cron() {
            return Optional.empty();
        }
    }

    public static final class FromYaml
    implements RepoConfig {
        private static final String UPDATE = "update";
        private static final String CRON = "cron";
        private final YamlMapping yaml;

        public FromYaml(YamlMapping yaml) {
            this.yaml = yaml;
        }

        public FromYaml(Optional<YamlMapping> yaml) {
            this(yaml.orElse(Yaml.createYamlMappingBuilder().build()));
        }

        @Override
        public Digest digest() {
            return Optional.ofNullable(this.yaml.string(RpmOptions.DIGEST.optionName())).map(dgst -> Digest.valueOf(dgst.toUpperCase(Locale.US))).orElse(Digest.SHA256);
        }

        @Override
        public NamingPolicy naming() {
            return Optional.ofNullable(this.yaml.string(RpmOptions.NAMING_POLICY.optionName())).map(naming -> StandardNamingPolicy.valueOf(naming.toUpperCase(Locale.US))).orElse(StandardNamingPolicy.SHA256);
        }

        @Override
        public boolean filelists() {
            return !Boolean.FALSE.toString().equals(this.yaml.string(RpmOptions.FILELISTS.optionName()));
        }

        @Override
        public UpdateMode mode() {
            return Optional.ofNullable(this.yaml.yamlMapping(UPDATE)).map(upd -> {
                UpdateMode res;
                YamlNode node = upd.value("on");
                if (node.type() == Node.MAPPING && node.asMapping().value(CRON) != null) {
                    res = UpdateMode.CRON;
                } else if (node.type() == Node.SCALAR && node.asScalar().value().equals("upload")) {
                    res = UpdateMode.UPLOAD;
                } else {
                    throw new ArtipieException("Repository settings section `upload` is incorrectly configured");
                }
                return res;
            }).orElse(UpdateMode.UPLOAD);
        }

        @Override
        public Optional<String> cron() {
            Optional<String> res = Optional.empty();
            if (this.mode() == UpdateMode.CRON) {
                res = Optional.of(this.yaml.yamlMapping(UPDATE).yamlMapping("on").string(CRON));
            }
            return res;
        }
    }

    public static enum UpdateMode {
        UPLOAD,
        CRON;

    }
}

