/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.asto.Copy;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.SubStorage;
import com.artipie.asto.lock.Lock;
import com.artipie.asto.lock.storage.StorageLock;
import com.artipie.asto.misc.UncheckedIOScalar;
import com.artipie.asto.streams.ContentAsStream;
import com.artipie.rpm.Digest;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.StandardNamingPolicy;
import com.artipie.rpm.asto.AstoChecksumAndName;
import com.artipie.rpm.asto.AstoRepoAdd;
import com.artipie.rpm.asto.AstoRepoRemove;
import com.artipie.rpm.http.RpmUpload;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlPrimaryChecksums;
import com.artipie.rpm.misc.PackagesDiff;
import hu.akarnokd.rxjava2.interop.CompletableInterop;
import io.reactivex.Completable;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.reactivestreams.Publisher;

public final class Rpm {
    private final Storage storage;
    private final RepoConfig config;

    public Rpm(Storage stg) {
        this(stg, StandardNamingPolicy.PLAIN, Digest.SHA256, false);
    }

    public Rpm(Storage stg, boolean filelists) {
        this(stg, StandardNamingPolicy.PLAIN, Digest.SHA256, filelists);
    }

    public Rpm(Storage stg, NamingPolicy naming, Digest dgst, boolean filelists) {
        this(stg, new RepoConfig.Simple(dgst, naming, filelists));
    }

    public Rpm(Storage storage, RepoConfig config) {
        this.storage = storage;
        this.config = config;
    }

    @Deprecated
    public Completable update(String key) {
        return this.update((Key)new Key.From(key));
    }

    @Deprecated
    public Completable update(Key key) {
        String[] parts = key.string().split("/");
        Object folder = parts.length == 1 ? Key.ROOT : new Key.From((String[])Arrays.stream(parts).limit(parts.length - 1).toArray(String[]::new));
        return this.batchUpdate((Key)folder);
    }

    @Deprecated
    public Completable batchUpdate(String prefix) {
        return this.batchUpdate((Key)new Key.From(prefix));
    }

    public Completable batchUpdate(Key prefix) {
        return this.doWithLock(prefix, () -> Completable.fromFuture(this.calcDiff(prefix).thenCompose(list -> {
            SubStorage sub = new SubStorage(prefix, this.storage);
            return new AstoRepoAdd((Storage)sub, this.config).perform().thenCompose(arg_0 -> this.lambda$null$1((Storage)sub, list, arg_0));
        }).toCompletableFuture()));
    }

    @Deprecated
    public Completable batchUpdateIncrementally(Key prefix) {
        return this.batchUpdate(prefix);
    }

    private Completable doWithLock(Key target, Supplier<Completable> operation) {
        StorageLock lock = new StorageLock(this.storage, target, Instant.now().plus(Duration.ofHours(1L)));
        return Completable.fromFuture(lock.acquire().thenCompose(nothing -> (CompletionStage)((Completable)operation.get()).to(CompletableInterop.await())).thenCompose(arg_0 -> Rpm.lambda$doWithLock$5((Lock)lock, arg_0)).toCompletableFuture());
    }

    private CompletionStage<Collection<String>> calcDiff(Key prefix) {
        return ((CompletableFuture)this.storage.list((Key)new Key.From(prefix, new String[]{"repodata"})).thenApply(list -> list.stream().filter(item -> item.string().contains(XmlPackage.PRIMARY.lowercase()) && item.string().endsWith("xml.gz")).findFirst())).thenCompose(opt -> {
            SubStorage sub = new SubStorage(prefix, this.storage);
            CompletionStage res = opt.isPresent() ? ((CompletableFuture)((CompletableFuture)this.storage.value((Key)opt.get()).thenCompose(val -> new ContentAsStream((Publisher)val).process(input -> new XmlPrimaryChecksums((InputStream)new UncheckedIOScalar(() -> new GZIPInputStream((InputStream)input)).value()).read()))).thenCompose(primary -> new AstoChecksumAndName(this.storage, this.config.digest()).calculate(prefix).thenApply(repo -> new PackagesDiff((Map<String, String>)primary, (Map<String, String>)repo)))).thenCompose(diff -> Rpm.copyPackagesToAdd((Storage)sub, diff.toAdd().stream().map(Key.From::new).collect(Collectors.toList())).thenApply(nothing -> diff.toDelete().values())) : ((CompletableFuture)((CompletableFuture)sub.list(Key.ROOT).thenApply(list -> list.stream().filter(item -> item.string().endsWith("rpm")))).thenCompose(rpms -> Rpm.copyPackagesToAdd((Storage)sub, rpms.collect(Collectors.toList())))).thenApply(nothing -> Collections.emptySet());
            return res;
        });
    }

    private static CompletableFuture<Void> copyPackagesToAdd(Storage asto, List<Key> rpms) {
        return new Copy(asto, rpms).copy((Storage)new SubStorage(RpmUpload.TO_ADD, asto));
    }

    private static /* synthetic */ CompletionStage lambda$doWithLock$5(Lock lock, Object nothing) {
        return lock.release();
    }

    private /* synthetic */ CompletionStage lambda$null$1(Storage sub, Collection list, Void nothing) {
        return new AstoRepoRemove(sub, this.config).perform(list);
    }
}

