/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.streams.StorageValuePipeline;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletionStage;
import java.util.zip.GZIPOutputStream;

final class AstoArchive {
    private final Storage asto;

    AstoArchive(Storage asto) {
        this.asto = asto;
    }

    public CompletionStage<Void> gzip(Key key) {
        return new StorageValuePipeline(this.asto, key).process((inpt, out) -> {
            try (GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)out);){
                int length;
                byte[] buffer = new byte[8192];
                while ((length = ((InputStream)inpt.get()).read(buffer)) >= 0) {
                    gzos.write(buffer, 0, length);
                }
                gzos.finish();
            }
            catch (IOException err) {
                throw new ArtipieIOException(err);
            }
        });
    }
}

