/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.meta.XmlPackage;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

final class AstoMetadataNames {
    private static final String REPOMD = "repomd.xml";
    private final Storage asto;
    private final RepoConfig cnfg;

    AstoMetadataNames(Storage asto, RepoConfig cnfg) {
        this.asto = asto;
        this.cnfg = cnfg;
    }

    CompletionStage<Map<Key, Key>> prepareNames(Key temp) {
        RxStorageWrapper rxsto = new RxStorageWrapper(this.asto);
        return (CompletionStage)rxsto.list(temp).flatMapObservable(Observable::fromIterable).filter(key -> new XmlPackage.Stream(this.cnfg.filelists()).get().anyMatch(item -> key.string().endsWith(item.name()))).flatMapSingle(key -> rxsto.value(key).flatMap(val -> Single.fromFuture(new ContentDigest(val, () -> this.cnfg.digest().messageDigest()).hex().thenApply(hex -> new ImmutablePair(key, (Object)new Key.From(this.cnfg.naming().fullName(new XmlPackage.Stream(this.cnfg.filelists()).get().filter(item -> key.string().contains(item.name())).findFirst().get(), (String)hex)))).toCompletableFuture()))).toMap(Pair::getKey, Pair::getValue).flatMap(map -> {
            Key.From repomd = new Key.From(temp, new String[]{REPOMD});
            return rxsto.exists((Key)repomd).map(exists -> {
                if (exists.booleanValue()) {
                    map.put(repomd, new Key.From(new String[]{"repodata", REPOMD}));
                }
                return map;
            });
        }).to(SingleInterop.get());
    }
}

