/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.ArtipieException;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.misc.UncheckedIOFunc;
import com.artipie.asto.streams.ContentAsStream;
import com.artipie.rpm.Digest;
import com.artipie.rpm.RpmMetadata;
import com.artipie.rpm.pkg.Checksum;
import com.artipie.rpm.pkg.FilePackageHeader;
import com.artipie.rpm.pkg.Package;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.reactivestreams.Publisher;
import org.redline_rpm.header.Header;

public final class AstoRpmPackage {
    private final Storage asto;
    private final Digest dgst;

    public AstoRpmPackage(Storage asto, Digest dgst) {
        this.asto = asto;
        this.dgst = dgst;
    }

    public CompletionStage<Package.Meta> packageMeta(Key key) {
        return this.packageMeta(key, key.string());
    }

    public CompletionStage<Package.Meta> packageMeta(Key key, String path) {
        return ((CompletableFuture)this.asto.value(key).thenCompose(val -> new ContentDigest(val, this.dgst::messageDigest).hex().thenApply(hex -> new ImmutablePair(hex, val.size().orElseThrow(() -> new ArtipieException("Content size unknown!")))))).thenCompose(pair -> this.asto.value(key).thenCompose(val -> new ContentAsStream((Publisher)val).process((Function)new UncheckedIOFunc(input -> new FilePackageHeader((InputStream)input).header())).thenApply(header -> new RpmMetadata.RpmItem((Header)header, (long)((Long)pair.getValue()), new Checksum.Simple(this.dgst, (String)pair.getKey()), path))));
    }
}

