/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.asto.AstoRepoRemove;
import com.artipie.rpm.http.RpmUpload;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;

public final class RpmRemove
implements Slice {
    public static final Key TO_RM = new Key.From(".remove");
    private final Storage asto;
    private final RepoConfig cnfg;

    public RpmRemove(Storage asto, RepoConfig cnfg) {
        this.asto = asto;
        this.cnfg = cnfg;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RpmUpload.Request request = new RpmUpload.Request(line);
        Key.From temp = new Key.From(TO_RM, request.file());
        return new AsyncResponse(((CompletableFuture)this.asto.save((Key)temp, Content.EMPTY).thenApply(nothing -> RpmRemove.checksum(headers))).thenCompose(arg_0 -> this.lambda$response$5(request, (Key)temp, arg_0)));
    }

    private CompletionStage<Boolean> validate(Key file, Pair<String, String> checksum) {
        return this.asto.exists(file).thenCompose(exists -> {
            CompletionStage<Boolean> res = CompletableFuture.completedFuture(false);
            if (exists.booleanValue()) {
                res = this.asto.value(file).thenCompose(val -> new ContentDigest(val, () -> new Digests.FromString((String)checksum.getKey()).get().get()).hex().thenApply(pkg -> pkg.equals(checksum.getValue())));
            }
            return res;
        });
    }

    private static Optional<Pair<String, String>> checksum(Iterable<Map.Entry<String, String>> headers) {
        String name = "x-checksum-";
        return StreamSupport.stream(headers.spliterator(), false).map(hdr -> new ImmutablePair((Object)((String)hdr.getKey()).toLowerCase(Locale.US), hdr.getValue())).filter(hdr -> ((String)hdr.getKey()).startsWith("x-checksum-")).findFirst().map(hdr -> new ImmutablePair((Object)((String)hdr.getKey()).substring("x-checksum-".length()), hdr.getValue()));
    }

    private /* synthetic */ CompletionStage lambda$response$5(RpmUpload.Request request, Key temp, Optional checksum) {
        return ((CompletionStage)checksum.map(sum -> this.validate(request.file(), (Pair<String, String>)sum)).orElse(CompletableFuture.completedFuture(request.force()))).thenCompose(valid -> {
            CompletionStage<Object> res = CompletableFuture.completedFuture(RsStatus.ACCEPTED);
            if (valid.booleanValue() && this.cnfg.mode() == RepoConfig.UpdateMode.UPLOAD && !request.skipUpdate()) {
                res = new AstoRepoRemove(this.asto, this.cnfg).perform().thenApply(ignored -> RsStatus.ACCEPTED);
            } else if (!valid.booleanValue()) {
                res = this.asto.delete(temp).thenApply(nothing -> RsStatus.BAD_REQUEST);
            }
            return res.thenApply(RsWithStatus::new);
        });
    }
}

