/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.asto.AstoRepoAdd;
import com.google.common.base.Splitter;
import com.google.common.collect.Streams;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public final class RpmUpload
implements Slice {
    public static final Key TO_ADD = new Key.From(".add");
    private final Storage asto;
    private final RepoConfig config;

    RpmUpload(Storage storage, RepoConfig config) {
        this.asto = storage;
        this.config = config;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Request request = new Request(line);
        Key key = request.file();
        CompletableFuture conflict = request.override() ? CompletableFuture.completedFuture(false) : this.asto.exists(key);
        return new AsyncResponse(conflict.thenCompose(conflicts -> {
            CompletionStage<Object> status = conflicts != false ? CompletableFuture.completedFuture(RsStatus.CONFLICT) : ((CompletableFuture)this.asto.save((Key)new Key.From(TO_ADD, key), (Content)new Content.From(body)).thenCompose(ignored -> {
                CompletionStage<Void> result = request.skipUpdate() || this.config.mode() == RepoConfig.UpdateMode.CRON ? CompletableFuture.allOf(new CompletableFuture[0]) : new AstoRepoAdd(this.asto, this.config).perform();
                return result;
            })).thenApply(nothing -> RsStatus.ACCEPTED);
            return status;
        }).thenApply(RsWithStatus::new));
    }

    static final class Request {
        public static final Pattern PTRN = Pattern.compile("^/(?<rpm>.*\\.rpm)");
        private final String line;

        Request(String line) {
            this.line = line;
        }

        public Key file() {
            return new Key.From(this.path().group("rpm"));
        }

        public boolean override() {
            return this.hasParamValue("override=true");
        }

        public boolean skipUpdate() {
            return this.hasParamValue("skip_update=true");
        }

        public boolean force() {
            return this.hasParamValue("force=true");
        }

        private Matcher path() {
            String path = new RequestLineFrom(this.line).uri().getPath();
            Matcher matcher = PTRN.matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException(String.format("Unexpected path: %s", path));
            }
            return matcher;
        }

        private boolean hasParamValue(String param) {
            return Optional.ofNullable(new RequestLineFrom(this.line).uri().getQuery()).map(query -> Streams.stream((Iterable)Splitter.on((String)"&").split((CharSequence)query))).orElse(Stream.empty()).anyMatch(part -> part.equals(param));
        }
    }
}

