/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.CrCompareDependency;
import com.artipie.rpm.meta.RpmDependency;
import com.artipie.rpm.meta.XmlEvent;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.misc.UncheckedConsumer;
import com.artipie.rpm.pkg.HeaderTags;
import com.artipie.rpm.pkg.Package;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class XmlEventPrimary
implements XmlEvent {
    private static final int RPMSENSE_PREREQ = 64;
    private static final int RPMSENSE_SCRIPT_PRE = 512;
    private static final int RPMSENSE_SCRIPT_POST = 1024;
    private static final String PRFX = "rpm";
    private static final String NS_URL = XmlPackage.PRIMARY.xmlNamespaces().get("rpm");

    @Override
    public void add(XMLEventWriter writer, Package.Meta meta) throws IOException {
        XMLEventFactory events = XMLEventFactory.newFactory();
        HeaderTags tags = new HeaderTags(meta);
        try {
            writer.add(events.createStartElement("", "", "package"));
            writer.add(events.createAttribute("type", PRFX));
            XmlEventPrimary.addElement(writer, "name", tags.name());
            XmlEventPrimary.addElement(writer, "arch", tags.arch());
            writer.add(events.createStartElement("", "", "version"));
            writer.add(events.createAttribute("epoch", String.valueOf(tags.epoch())));
            writer.add(events.createAttribute("rel", tags.release()));
            writer.add(events.createAttribute("ver", tags.version()));
            writer.add(events.createEndElement("", "", "version"));
            writer.add(events.createStartElement("", "", "checksum"));
            writer.add(events.createAttribute("type", meta.checksum().digest().type()));
            writer.add(events.createAttribute("pkgid", "YES"));
            writer.add(events.createCharacters(meta.checksum().hex()));
            writer.add(events.createEndElement("", "", "checksum"));
            XmlEventPrimary.addElement(writer, "summary", tags.summary());
            XmlEventPrimary.addElement(writer, "description", tags.description());
            XmlEventPrimary.addElement(writer, "packager", tags.packager());
            XmlEventPrimary.addElement(writer, "url", tags.url());
            XmlEventPrimary.addAttributes(writer, "time", Stream.of(new ImmutablePair((Object)"file", (Object)String.valueOf(tags.fileTimes())), new ImmutablePair((Object)"build", (Object)String.valueOf(tags.buildTime()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
            XmlEventPrimary.addAttributes(writer, "size", Stream.of(new ImmutablePair((Object)"package", (Object)String.valueOf(meta.size())), new ImmutablePair((Object)"installed", (Object)String.valueOf(tags.installedSize())), new ImmutablePair((Object)"archive", (Object)String.valueOf(tags.archiveSize()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
            XmlEventPrimary.addAttributes(writer, "location", Collections.singletonMap("href", meta.href()));
            writer.add(events.createStartElement("", "", "format"));
            XmlEventPrimary.addElementWithNamespace(writer, "license", tags.license());
            XmlEventPrimary.addElementWithNamespace(writer, "vendor", tags.vendor());
            XmlEventPrimary.addElementWithNamespace(writer, "group", tags.group());
            XmlEventPrimary.addElementWithNamespace(writer, "buildhost", tags.buildHost());
            XmlEventPrimary.addElementWithNamespace(writer, "sourcerpm", tags.sourceRmp());
            XmlEventPrimary.addAttributes(writer, "header-range", NS_URL, PRFX, Stream.of(new ImmutablePair((Object)"start", (Object)String.valueOf(meta.range()[0])), new ImmutablePair((Object)"end", (Object)String.valueOf(meta.range()[1]))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
            XmlEventPrimary.addProvides(writer, tags);
            XmlEventPrimary.addRequires(writer, tags);
            XmlEventPrimary.addObsoletes(writer, tags);
            XmlEventPrimary.addConflicts(writer, tags);
            new XmlEvent.Files(XmlEventPrimary.filesFilter()).add(writer, meta);
            writer.add(events.createEndElement("", "", "format"));
            writer.add(events.createEndElement("", "", "package"));
        }
        catch (XMLStreamException err) {
            throw new IOException(err);
        }
    }

    private static void addProvides(XMLEventWriter writer, HeaderTags tags) throws XMLStreamException {
        XMLEventFactory events = XMLEventFactory.newFactory();
        writer.add(events.createStartElement(PRFX, NS_URL, "provides"));
        List<String> names = tags.providesNames();
        List<Optional<String>> flags = tags.providesFlags();
        List<HeaderTags.Version> versions = tags.providesVer();
        for (int ind = 0; ind < names.size(); ++ind) {
            writer.add(events.createStartElement(PRFX, NS_URL, "entry"));
            writer.add(events.createAttribute("name", names.get(ind)));
            XmlEventPrimary.addEntryAttr(writer, events, versions, ind, flags, HeaderTags.Flags.EQUAL.notation());
            writer.add(events.createEndElement(PRFX, NS_URL, "entry"));
        }
        writer.add(events.createEndElement(PRFX, NS_URL, "provides"));
    }

    private static void addRequires(XMLEventWriter writer, HeaderTags tags) throws XMLStreamException {
        XMLEventFactory events = XMLEventFactory.newFactory();
        writer.add(events.createStartElement(PRFX, NS_URL, "requires"));
        List<String> names = tags.requires();
        List<Optional<String>> flags = tags.requireFlags();
        List<Integer> intflags = tags.requireFlagsInts();
        List<HeaderTags.Version> versions = tags.requiresVer();
        HashMap<String, Integer> items = new HashMap<String, Integer>(names.size());
        HashSet<String> duplicates = new HashSet<String>(names.size());
        Set<String> files = new XmlEvent.Files(XmlEventPrimary.filesFilter()).files(tags);
        ArrayList<String> libcso = new ArrayList<String>(names.size());
        List<String> nprovides = tags.providesNames();
        List<HeaderTags.Version> vprovides = tags.providesVer();
        for (int ind = 0; ind < names.size(); ++ind) {
            String name = names.get(ind);
            if (XmlEventPrimary.checkRequiresInProvides(nprovides, vprovides, name, versions.get(ind), flags.get(ind)) || files.contains(name)) continue;
            if (name.startsWith("libc.so.")) {
                libcso.add(name);
                continue;
            }
            int pre = 0;
            if ((intflags.get(ind) & 0x640) != 0) {
                pre = 1;
            }
            String full = name.concat(flags.get(ind).orElse("")).concat(versions.get(ind).toString());
            if (!versions.get(ind).toString().isEmpty()) {
                full = full.concat(String.valueOf(pre));
            }
            if (!(name.startsWith("rpmlib(") || name.startsWith("config(") || duplicates.contains(full) || name.equals("/usr/sbin/glibc_post_upgrade.x86_64"))) {
                writer.add(events.createStartElement(PRFX, NS_URL, "entry"));
                writer.add(events.createAttribute("name", name));
                String item = String.join((CharSequence)"", name, versions.get(ind).toString());
                XmlEventPrimary.addEntryAttr(writer, events, versions, ind, flags, XmlEventPrimary.findFlag(flags, items, item));
                if (pre > 0) {
                    writer.add(events.createAttribute("pre", String.valueOf(pre)));
                }
                items.put(item, ind);
                writer.add(events.createEndElement(PRFX, NS_URL, "entry"));
            }
            duplicates.add(full);
        }
        if (!libcso.isEmpty()) {
            libcso.sort(new CrCompareDependency());
            writer.add(events.createStartElement(PRFX, NS_URL, "entry"));
            writer.add(events.createAttribute("name", (String)libcso.get(libcso.size() - 1)));
            writer.add(events.createEndElement(PRFX, NS_URL, "entry"));
        }
        writer.add(events.createEndElement(PRFX, NS_URL, "requires"));
    }

    private static void addObsoletes(XMLEventWriter writer, HeaderTags tags) throws XMLStreamException {
        List<String> names = tags.obsoletes();
        if (names.isEmpty()) {
            return;
        }
        XMLEventFactory events = XMLEventFactory.newFactory();
        writer.add(events.createStartElement(PRFX, NS_URL, "obsoletes"));
        List<Optional<String>> flags = tags.obsoletesFlags();
        List<HeaderTags.Version> versions = tags.obsoletesVer();
        for (int ind = 0; ind < names.size(); ++ind) {
            writer.add(events.createStartElement(PRFX, NS_URL, "entry"));
            writer.add(events.createAttribute("name", names.get(ind)));
            XmlEventPrimary.addEntryAttr(writer, events, versions, ind, flags, HeaderTags.Flags.EQUAL.notation());
            writer.add(events.createEndElement(PRFX, NS_URL, "entry"));
        }
        writer.add(events.createEndElement(PRFX, NS_URL, "obsoletes"));
    }

    private static void addConflicts(XMLEventWriter writer, HeaderTags tags) throws XMLStreamException {
        List<String> names = tags.conflicts();
        if (names.isEmpty()) {
            return;
        }
        XMLEventFactory events = XMLEventFactory.newFactory();
        writer.add(events.createStartElement(PRFX, NS_URL, "conflicts"));
        List<Optional<String>> flags = tags.conflictsFlags();
        List<HeaderTags.Version> versions = tags.conflictsVer();
        HashSet<String> items = new HashSet<String>(names.size());
        for (int ind = 0; ind < names.size(); ++ind) {
            String concat = names.get(ind).concat(versions.get(ind).toString()).concat(flags.get(ind).orElse(""));
            if (items.contains(concat)) continue;
            items.add(concat);
            writer.add(events.createStartElement(PRFX, NS_URL, "entry"));
            writer.add(events.createAttribute("name", names.get(ind)));
            XmlEventPrimary.addEntryAttr(writer, events, versions, ind, flags, HeaderTags.Flags.EQUAL.notation());
            writer.add(events.createEndElement(PRFX, NS_URL, "entry"));
        }
        writer.add(events.createEndElement(PRFX, NS_URL, "conflicts"));
    }

    private static void addElementWithNamespace(XMLEventWriter writer, String tag, String chars) throws XMLStreamException {
        XMLEventFactory events = XMLEventFactory.newFactory();
        writer.add(events.createStartElement(PRFX, NS_URL, tag));
        writer.add(events.createCharacters(chars));
        writer.add(events.createEndElement(PRFX, NS_URL, tag));
    }

    private static void addElement(XMLEventWriter writer, String tag, String chars) throws XMLStreamException {
        XMLEventFactory events = XMLEventFactory.newFactory();
        writer.add(events.createStartElement("", "", tag));
        writer.add(events.createCharacters(chars));
        writer.add(events.createEndElement("", "", tag));
    }

    private static void addAttributes(XMLEventWriter writer, String tag, String namespace, String prefix, Map<String, String> attrs) throws XMLStreamException {
        XMLEventFactory events = XMLEventFactory.newFactory();
        writer.add(events.createStartElement(prefix, namespace, tag));
        for (Map.Entry<String, String> attr : attrs.entrySet()) {
            writer.add(events.createAttribute(attr.getKey(), attr.getValue()));
        }
        writer.add(events.createEndElement(prefix, namespace, tag));
    }

    private static void addAttributes(XMLEventWriter writer, String tag, Map<String, String> attrs) throws XMLStreamException {
        XmlEventPrimary.addAttributes(writer, tag, "", "", attrs);
    }

    private static void addEntryAttr(XMLEventWriter writer, XMLEventFactory events, List<HeaderTags.Version> versions, int ind, List<Optional<String>> flags, String def) throws XMLStreamException {
        if (ind < versions.size() && !versions.get(ind).ver().isEmpty()) {
            writer.add(events.createAttribute("ver", versions.get(ind).ver()));
            writer.add(events.createAttribute("epoch", versions.get(ind).epoch()));
            versions.get(ind).rel().ifPresent(new UncheckedConsumer(rel -> writer.add(events.createAttribute("rel", (String)rel))));
            writer.add(events.createAttribute("flags", flags.get(ind).orElse(def)));
        }
    }

    private static String findFlag(List<Optional<String>> flags, Map<String, Integer> items, String item) {
        return Optional.ofNullable(items.get(item)).flatMap(flags::get).orElse(HeaderTags.Flags.EQUAL.notation());
    }

    private static boolean checkRequiresInProvides(List<String> nprovides, List<HeaderTags.Version> vprovides, String rname, HeaderTags.Version rversion, Optional<String> flag) {
        boolean res = false;
        for (int ind = 0; ind < nprovides.size(); ++ind) {
            if (!new RpmDependency(rname, rversion, flag).isSatisfiedBy(nprovides.get(ind), vprovides.get(ind))) continue;
            res = true;
            break;
        }
        return res;
    }

    private static Predicate<String> filesFilter() {
        return name -> name.startsWith("/var/") || name.equals("/boot") || name.startsWith("/boot/") || name.startsWith("/lib/") || name.startsWith("/lib64/") || "/lib64".equals(name) || "/lib".equals(name) || name.startsWith("/run/") || name.startsWith("/usr/") && !name.contains("/bin/") && !name.contains("/sbin/");
    }
}

