/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public enum XmlPackage {
    PRIMARY("metadata", java.util.stream.Stream.of(new ImmutablePair((Object)"", (Object)"http://linux.duke.edu/metadata/common"), new ImmutablePair((Object)"rpm", (Object)"http://linux.duke.edu/metadata/rpm")).collect(Collectors.toMap(Pair::getKey, Pair::getValue))),
    OTHER("otherdata", Collections.singletonMap("", "http://linux.duke.edu/metadata/other")),
    FILELISTS("filelists", Collections.singletonMap("", "http://linux.duke.edu/metadata/filelists"));

    private static final String SUFFIX = ".xml";
    private final String tagname;
    private final Map<String, String> namespaces;

    private XmlPackage(String tagname, Map<String, String> namespaces) {
        this.tagname = tagname;
        this.namespaces = namespaces;
    }

    public String tag() {
        return this.tagname;
    }

    public String lowercase() {
        return this.name().toLowerCase(Locale.getDefault());
    }

    public String tempPrefix() {
        return String.format("%s-", this.lowercase());
    }

    public Map<String, String> xmlNamespaces() {
        return this.namespaces;
    }

    public static final class Stream {
        private final boolean filelists;

        public Stream(boolean filelists) {
            this.filelists = filelists;
        }

        public java.util.stream.Stream<XmlPackage> get() {
            java.util.stream.Stream<XmlPackage> res = this.filelists ? java.util.stream.Stream.of(XmlPackage.values()) : java.util.stream.Stream.of(PRIMARY, OTHER);
            return res;
        }
    }
}

