/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.MergedXmlPackage;
import com.artipie.rpm.meta.XmlException;
import com.artipie.rpm.meta.XmlMaid;
import com.artipie.rpm.meta.XmlPackage;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public final class XmlPrimaryMaid
implements XmlMaid {
    private final Path file;

    public XmlPrimaryMaid(Path file) {
        this.file = file;
    }

    @Override
    public long clean(Collection<String> checksums) throws IOException {
        long res;
        Path tmp = this.file.getParent().resolve(String.format("%s.part", this.file.getFileName().toString()));
        try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);
             OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);){
            res = new Stream(in, out).clean(checksums);
        }
        catch (IOException ex) {
            throw new XmlException(ex);
        }
        Files.move(tmp, this.file, StandardCopyOption.REPLACE_EXISTING);
        return res;
    }

    public static final class Stream
    implements XmlMaid {
        private final InputStream input;
        private final OutputStream out;

        public Stream(InputStream input, OutputStream out) {
            this.input = input;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long clean(Collection<String> ids) throws IOException {
            long res;
            try {
                XMLEventReader reader = new InputFactoryImpl().createXMLEventReader(this.input);
                XMLEventWriter writer = new OutputFactoryImpl().createXMLEventWriter(this.out);
                try {
                    XMLEventFactory events = XMLEventFactory.newFactory();
                    MergedXmlPackage.startDocument(writer, "-1", XmlPackage.PRIMARY);
                    res = Stream.processPackages(ids, reader, writer);
                    writer.add(events.createSpace("\n"));
                    writer.add(events.createEndElement(new QName(XmlPackage.PRIMARY.tag()), Collections.emptyIterator()));
                }
                finally {
                    writer.close();
                    reader.close();
                }
            }
            catch (XMLStreamException err) {
                throw new IOException(err);
            }
            return res;
        }

        private static long processPackages(Collection<String> checksums, XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
            ArrayList<XMLEvent> pckg = new ArrayList<XMLEvent>(10);
            boolean valid = true;
            long cnt = 0L;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (Stream.isTag(event, "package")) {
                    pckg.clear();
                }
                pckg.add(event);
                if (Stream.isTag(event, "checksum")) {
                    event = reader.nextEvent();
                    pckg.add(event);
                    boolean bl = valid = event.isCharacters() && !checksums.contains(event.asCharacters().getData());
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals("package") || !valid) continue;
                ++cnt;
                for (XMLEvent item : pckg) {
                    writer.add(item);
                }
            }
            return cnt;
        }

        private static boolean isTag(XMLEvent event, String tag) {
            return event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(tag);
        }
    }
}

