/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.asto.misc.UncheckedIOScalar;
import com.artipie.rpm.pkg.InvalidPackageException;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import org.redline_rpm.ReadableChannelWrapper;
import org.redline_rpm.Scanner;
import org.redline_rpm.header.Format;
import org.redline_rpm.header.Header;

public final class FilePackageHeader {
    private final InputStream pckg;

    public FilePackageHeader(InputStream file) {
        this.pckg = file;
    }

    public FilePackageHeader(Path file) {
        this((InputStream)new UncheckedIOScalar(() -> Files.newInputStream(file, new OpenOption[0])).value());
    }

    public Header header() throws InvalidPackageException, IOException {
        try (ReadableByteChannel chan = Channels.newChannel(this.pckg);){
            Format format;
            try {
                format = new Scanner(new PrintStream(Logger.stream((Level)Level.FINE, (Object)this))).run(new ReadableChannelWrapper(chan));
            }
            catch (RuntimeException ex) {
                throw new InvalidPackageException(ex);
            }
            Header header = format.getHeader();
            Logger.debug((Object)this, (String)"header: %s", (Object[])new Object[]{header.toString()});
            int bufsize = 1024;
            int read = 1;
            while (read > 0) {
                read = chan.read(ByteBuffer.allocate(1024));
            }
            Header header2 = header;
            return header2;
        }
    }
}

