/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.rpm.Digest;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.RpmOptions;
import com.artipie.rpm.StandardNamingPolicy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class CliArguments {
    private static final Options OPTIONS = new Options().addOption(RpmOptions.DIGEST.option()).addOption(RpmOptions.NAMING_POLICY.option()).addOption(RpmOptions.FILELISTS.option()).addOption(RpmOptions.UPDATE.option());
    private final CommandLine cli;

    public CliArguments(CommandLine cli) {
        this.cli = cli;
    }

    public CliArguments(String ... args) {
        this(CliArguments.parsed(args));
    }

    public Path repository() {
        List args = this.cli.getArgList();
        if (args.isEmpty()) {
            throw new IllegalArgumentException(String.format("Expected repository path but got: %s", args));
        }
        return Paths.get((String)args.get(0), new String[0]);
    }

    public RepoConfig config() {
        return new FromCliArguments(this.cli);
    }

    private static CommandLine parsed(String ... args) {
        try {
            return new DefaultParser().parse(OPTIONS, args);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(String.format("Can't parse arguments '%s'", Arrays.asList(args)), ex);
        }
    }

    public static final class FromCliArguments
    implements RepoConfig {
        private final CommandLine cli;

        private FromCliArguments(CommandLine cli) {
            this.cli = cli;
        }

        @Override
        public Digest digest() {
            return Digest.valueOf(this.cli.getOptionValue(RpmOptions.DIGEST.option().getOpt(), "sha256").toUpperCase(Locale.US));
        }

        @Override
        public NamingPolicy naming() {
            return StandardNamingPolicy.valueOf(this.cli.getOptionValue(RpmOptions.NAMING_POLICY.option().getOpt(), "plain").toUpperCase(Locale.US));
        }

        @Override
        public boolean filelists() {
            return Boolean.parseBoolean(this.cli.getOptionValue(RpmOptions.FILELISTS.option().getOpt(), "true"));
        }

        @Override
        public RepoConfig.UpdateMode mode() {
            return Optional.ofNullable(this.cli.getOptionValue(RpmOptions.UPDATE.option().getOpt())).map(ignored -> RepoConfig.UpdateMode.CRON).orElse(RepoConfig.UpdateMode.UPLOAD);
        }

        @Override
        public Optional<String> cron() {
            return Optional.ofNullable(this.cli.getOptionValue(RpmOptions.UPDATE.option().getOpt()));
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException("Method name() is not supported");
        }
    }
}

