/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.rpm.Digest;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.meta.XmlPackage;
import java.io.IOException;
import java.nio.file.Path;

public enum StandardNamingPolicy implements NamingPolicy
{
    PLAIN(new NamingPolicy(){

        @Override
        public String name(String source, Path content) {
            return source;
        }

        @Override
        public String fullName(XmlPackage source, String prefix) {
            return String.format("repodata/%s.xml.gz", source.lowercase());
        }
    }),
    SHA1(new NamingPolicy.HashPrefixed(Digest.SHA1)),
    SHA256(new NamingPolicy.HashPrefixed(Digest.SHA256));

    private final NamingPolicy origin;

    private StandardNamingPolicy(NamingPolicy origin) {
        this.origin = origin;
    }

    @Override
    public String name(String source, Path content) throws IOException {
        return this.origin.name(source, content);
    }

    @Override
    public String fullName(XmlPackage source, String prefix) {
        return this.origin.fullName(source, prefix);
    }
}

