/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.rpm.Digest;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class AstoChecksumAndName {
    private final Storage asto;
    private final Digest dgst;

    public AstoChecksumAndName(Storage asto, Digest dgst) {
        this.asto = asto;
        this.dgst = dgst;
    }

    public CompletionStage<Map<String, String>> calculate(Key key) {
        RxStorageWrapper rxsto = new RxStorageWrapper(this.asto);
        return (CompletionStage)rxsto.list(key).flatMapObservable(Observable::fromIterable).filter(item -> item.string().endsWith(".rpm")).flatMapSingle(item -> rxsto.value(item).flatMap(cnt -> Single.fromFuture(new ContentDigest(cnt, this.dgst::messageDigest).hex().toCompletableFuture())).map(hex -> new ImmutablePair((Object)AstoChecksumAndName.keyPart(key, item), hex))).toMap(Pair::getKey, Pair::getValue).to(SingleInterop.get());
    }

    private static String keyPart(Key exclude, Key item) {
        String res = item.string();
        if (!exclude.equals(Key.ROOT)) {
            res = item.string().substring(exclude.string().length() + 1);
        }
        return res;
    }
}

