/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.ArtipieException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.rpm.Digest;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionStage;

public final class AstoChecksumAndSize {
    private final Storage asto;
    private final Digest dgst;

    public AstoChecksumAndSize(Storage asto, Digest dgst) {
        this.asto = asto;
        this.dgst = dgst;
    }

    CompletionStage<Void> calculate(Key key) {
        return this.asto.value(key).thenCompose(val -> new ContentDigest(val, this.dgst::messageDigest).hex().thenCompose(hex -> this.asto.save((Key)new Key.From(String.format("%s.%s", key, this.dgst.name())), (Content)new Content.From(String.format("%s %d", hex, val.size().orElseThrow(() -> new ArtipieException("Content size unknown!"))).getBytes(StandardCharsets.US_ASCII)))));
    }
}

