/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.ArtipieException;
import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentAs;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.asto.streams.StorageValuePipeline;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlRepomd;
import com.artipie.rpm.pkg.Checksum;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class AstoCreateRepomd {
    private final Storage asto;
    private final RepoConfig cnfg;

    public AstoCreateRepomd(Storage asto, RepoConfig cnfg) {
        this.asto = asto;
        this.cnfg = cnfg;
    }

    public CompletionStage<Void> perform(Key temp) {
        return this.openChecksums(temp).thenCompose(open -> this.gzipedChecksums(temp).thenCompose(gziped -> new StorageValuePipeline(this.asto, (Key)new Key.From(temp, new String[]{"repomd.xml"})).process((opt, out) -> {
            try (XmlRepomd repomd = new XmlRepomd((OutputStream)out);){
                repomd.begin(System.currentTimeMillis() / 1000L);
                new XmlPackage.Stream(this.cnfg.filelists()).get().filter(item -> gziped.containsKey(item) && open.containsKey(item)).forEach(type -> {
                    try (XmlRepomd.Data data = repomd.beginData(type.lowercase());){
                        Checksum gzsum = this.checksum((Map<XmlPackage, String>)gziped, (XmlPackage)((Object)((Object)((Object)((Object)type)))));
                        data.gzipChecksum(gzsum);
                        data.openChecksum(this.checksum((Map<XmlPackage, String>)open, (XmlPackage)((Object)((Object)((Object)((Object)type))))));
                        data.location(this.cnfg.naming().fullName((XmlPackage)((Object)((Object)((Object)((Object)type)))), gzsum.hex()));
                        data.gzipSize(AstoCreateRepomd.size(gziped, type));
                        data.openSize(AstoCreateRepomd.size(open, type));
                    }
                    catch (IOException | XMLStreamException err) {
                        throw new ArtipieIOException("Failed to update repomd.xml", (Throwable)err);
                    }
                });
            }
        })));
    }

    private CompletionStage<Map<XmlPackage, String>> gzipedChecksums(Key temp) {
        RxStorageWrapper rxsto = new RxStorageWrapper(this.asto);
        return (CompletionStage)rxsto.list(temp).flatMapObservable(Observable::fromIterable).filter(key -> !key.string().endsWith(this.cnfg.digest().name())).flatMapSingle(key -> rxsto.value(key).flatMap(val -> Single.fromFuture(new ContentDigest(val, () -> this.cnfg.digest().messageDigest()).hex().thenApply(hex -> new ImmutablePair((Object)this.pckgType((Key)key), (Object)String.format("%s %d", hex, val.size().get()))).toCompletableFuture()))).toMap(Pair::getKey, Pair::getValue).to(SingleInterop.get());
    }

    private CompletionStage<Map<XmlPackage, String>> openChecksums(Key temp) {
        RxStorageWrapper rxsto = new RxStorageWrapper(this.asto);
        return (CompletionStage)rxsto.list(temp).flatMapObservable(Observable::fromIterable).filter(key -> key.string().endsWith(this.cnfg.digest().name())).flatMapSingle(key -> ((Single)rxsto.value(key).to((Function)ContentAs.STRING)).map(str -> new ImmutablePair((Object)this.pckgType((Key)key), str))).toMap(Pair::getKey, Pair::getValue).to(SingleInterop.get());
    }

    private XmlPackage pckgType(Key key) {
        return new XmlPackage.Stream(this.cnfg.filelists()).get().filter(item -> key.string().contains(item.name())).findFirst().orElseThrow(() -> new ArtipieException("Unknown metadata file name!"));
    }

    private Checksum checksum(Map<XmlPackage, String> map, XmlPackage type) {
        return new Checksum.Simple(this.cnfg.digest(), map.get((Object)type).split(" ")[0]);
    }

    private static long size(Map<XmlPackage, String> map, XmlPackage type) {
        return Long.parseLong(map.get((Object)type).split(" ")[1]);
    }
}

