/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.key.KeyExcludeFirst;
import com.artipie.asto.lock.storage.StorageLock;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.asto.AstoCreateRepomd;
import com.artipie.rpm.asto.AstoMetadataNames;
import com.artipie.rpm.asto.AstoMetadataRemove;
import com.artipie.rpm.http.RpmRemove;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class AstoRepoRemove {
    private static final Key META = new Key.From("repodata");
    private final Storage asto;
    private final RepoConfig cnfg;

    public AstoRepoRemove(Storage asto, RepoConfig cnfg) {
        this.asto = asto;
        this.cnfg = cnfg;
    }

    public CompletionStage<Void> perform(Collection<String> checksums) {
        return new AstoMetadataRemove(this.asto, this.cnfg).perform(checksums).thenCompose(temp -> new AstoCreateRepomd(this.asto, this.cnfg).perform((Key)temp).thenCompose(nothing -> new AstoMetadataNames(this.asto, this.cnfg).prepareNames((Key)temp).thenCompose(keys -> {
            StorageLock lock = new StorageLock(this.asto, META);
            return lock.acquire().thenCompose(ignored -> this.remove(META)).thenCompose(ignored -> CompletableFuture.allOf((CompletableFuture[])keys.entrySet().stream().map(entry -> this.asto.move((Key)entry.getKey(), (Key)entry.getValue())).toArray(CompletableFuture[]::new))).thenCompose(ignored -> lock.release()).thenCompose(ignored -> this.remove((Key)temp));
        })));
    }

    public CompletionStage<Void> perform() {
        return this.checksums().thenCompose(this::perform).thenCompose(ignored -> this.asto.list(RpmRemove.TO_RM).thenCompose(list -> CompletableFuture.allOf((CompletableFuture[])list.stream().map(key -> this.asto.delete(key).thenCompose(nothing -> this.asto.delete(AstoRepoRemove.removeTemp(key)))).toArray(CompletableFuture[]::new))));
    }

    private CompletableFuture<Void> remove(Key key) {
        return this.asto.list(key).thenCompose(list -> CompletableFuture.allOf((CompletableFuture[])list.stream().map(arg_0 -> ((Storage)this.asto).delete(arg_0)).toArray(CompletableFuture[]::new)));
    }

    private CompletionStage<List<String>> checksums() {
        RxStorageWrapper rxsto = new RxStorageWrapper(this.asto);
        return (CompletionStage)rxsto.list(RpmRemove.TO_RM).flatMapObservable(Observable::fromIterable).map(AstoRepoRemove::removeTemp).flatMapSingle(key -> rxsto.value(key).flatMap(val -> Single.fromFuture(new ContentDigest(val, () -> this.cnfg.digest().messageDigest()).hex().toCompletableFuture()))).toList().to(SingleInterop.get());
    }

    private static Key removeTemp(Key key) {
        return new KeyExcludeFirst(key, RpmRemove.TO_RM.string());
    }
}

