/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.MergedXml;
import com.artipie.rpm.meta.XmlEvent;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.pkg.Package;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public final class MergedXmlPackage
implements MergedXml {
    private final Optional<InputStream> input;
    private final OutputStream out;
    private final XmlPackage type;
    private final MergedXml.Result res;

    public MergedXmlPackage(Optional<InputStream> input, OutputStream out, XmlPackage type, MergedXml.Result res) {
        this.input = input;
        this.out = out;
        this.type = type;
        this.res = res;
    }

    public MergedXmlPackage(InputStream input, OutputStream out, XmlPackage type, MergedXml.Result res) {
        this(Optional.of(input), out, type, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergedXml.Result merge(Collection<Package.Meta> packages, XmlEvent event) throws IOException {
        try {
            Optional<Object> reader = Optional.empty();
            if (this.input.isPresent()) {
                reader = Optional.of(new InputFactoryImpl().createXMLEventReader(this.input.get()));
            }
            XMLEventWriter writer = new OutputFactoryImpl().createXMLEventWriter(this.out);
            try {
                XMLEventFactory events = XMLEventFactory.newFactory();
                MergedXmlPackage.startDocument(writer, String.valueOf(this.res.count()), this.type);
                if (reader.isPresent()) {
                    this.process(this.res.checksums(), (XMLEventReader)reader.get(), writer);
                }
                for (Package.Meta item : packages) {
                    event.add(writer, item);
                }
                writer.add(events.createSpace("\n"));
                writer.add(events.createEndElement(new QName(this.type.tag()), Collections.emptyIterator()));
            }
            finally {
                writer.close();
                if (reader.isPresent()) {
                    ((XMLEventReader)reader.get()).close();
                }
            }
        }
        catch (XMLStreamException err) {
            throw new IOException(err);
        }
        return this.res;
    }

    static void startDocument(XMLEventWriter writer, String cnt, XmlPackage type) throws XMLStreamException {
        XMLEventFactory events = XMLEventFactory.newFactory();
        writer.add(events.createStartDocument(StandardCharsets.UTF_8.displayName(), "1.0"));
        writer.add(events.createStartElement("", "", type.tag()));
        for (Map.Entry<String, String> item : type.xmlNamespaces().entrySet()) {
            writer.add(events.createNamespace(item.getKey(), item.getValue()));
        }
        writer.add(events.createAttribute("packages", cnt));
        writer.add(events.createSpace("\n"));
    }

    private void process(Collection<String> ids, XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        XMLEvent event;
        boolean valid = true;
        reader.nextEvent();
        reader.nextEvent();
        while (reader.hasNext() && !MergedXmlPackage.isEndTag(event = reader.nextEvent(), this.type.tag())) {
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("package")) {
                boolean bl = valid = !ids.contains(event.asStartElement().getAttributeByName(new QName("pkgid")).getValue());
            }
            if (valid) {
                writer.add(event);
            }
            if (!MergedXmlPackage.isEndTag(event, "package")) continue;
            valid = true;
        }
    }

    private static boolean isEndTag(XMLEvent event, String tag) {
        return event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(tag);
    }
}

