/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.MergedXml;
import com.artipie.rpm.meta.MergedXmlPackage;
import com.artipie.rpm.meta.XmlEvent;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.pkg.Package;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public final class MergedXmlPrimary
implements MergedXml {
    private final Optional<InputStream> input;
    private final OutputStream out;

    public MergedXmlPrimary(Optional<InputStream> input, OutputStream out) {
        this.input = input;
        this.out = out;
    }

    public MergedXmlPrimary(InputStream input, OutputStream out) {
        this(Optional.of(input), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergedXml.Result merge(Collection<Package.Meta> packages, XmlEvent event) throws IOException {
        AtomicLong res = new AtomicLong();
        List<String> checksums = Collections.emptyList();
        try {
            Optional<Object> reader = Optional.empty();
            if (this.input.isPresent()) {
                reader = Optional.of(new InputFactoryImpl().createXMLEventReader(this.input.get()));
            }
            XMLEventWriter writer = new OutputFactoryImpl().createXMLEventWriter(this.out);
            try {
                XMLEventFactory events = XMLEventFactory.newFactory();
                MergedXmlPackage.startDocument(writer, "-1", XmlPackage.PRIMARY);
                if (reader.isPresent()) {
                    checksums = MergedXmlPrimary.processPackages(packages.stream().map(Package.Meta::href).collect(Collectors.toSet()), (XMLEventReader)reader.get(), writer, res);
                }
                for (Package.Meta item : packages) {
                    event.add(writer, item);
                    res.incrementAndGet();
                }
                writer.add(events.createSpace("\n"));
                writer.add(events.createEndElement(new QName(XmlPackage.PRIMARY.tag()), Collections.emptyIterator()));
            }
            finally {
                writer.close();
                if (reader.isPresent()) {
                    ((XMLEventReader)reader.get()).close();
                }
            }
        }
        catch (XMLStreamException err) {
            throw new IOException(err);
        }
        return new MergedXml.Result(res.get(), checksums);
    }

    private static Collection<String> processPackages(Set<String> locations, XMLEventReader reader, XMLEventWriter writer, AtomicLong cnt) throws XMLStreamException {
        ArrayList<XMLEvent> pckg = new ArrayList<XMLEvent>(10);
        boolean valid = true;
        ArrayList<String> res = new ArrayList<String>(locations.size());
        String checksum = "123";
        reader.nextEvent();
        reader.nextEvent();
        while (reader.hasNext()) {
            boolean endpackage;
            XMLEvent event = reader.nextEvent();
            if (MergedXmlPrimary.isTag(event, "package")) {
                pckg.clear();
            }
            pckg.add(event);
            if (MergedXmlPrimary.isTag(event, "checksum")) {
                event = reader.nextEvent();
                pckg.add(event);
                checksum = event.asCharacters().getData();
            }
            if (MergedXmlPrimary.isTag(event, "location")) {
                valid = event.isStartElement() && !locations.contains(event.asStartElement().getAttributeByName(new QName("href")).getValue());
            }
            boolean bl = endpackage = event.isEndElement() && event.asEndElement().getName().getLocalPart().equals("package");
            if (endpackage && valid) {
                cnt.incrementAndGet();
                for (XMLEvent item : pckg) {
                    writer.add(item);
                }
                continue;
            }
            if (!endpackage) continue;
            res.add(checksum);
        }
        return res;
    }

    private static boolean isTag(XMLEvent event, String tag) {
        return event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(tag);
    }
}

