/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlException;
import com.artipie.rpm.meta.XmlWriterWrap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class XmlFile
extends XmlWriterWrap {
    private static final XMLOutputFactory FACTORY = XMLOutputFactory.newInstance();
    private final OutputStream stream;

    XmlFile(Path path) {
        this(XmlFile.outputStream(path));
    }

    XmlFile(OutputStream out) {
        super(XmlFile.xmlStreamWriter(out));
        this.stream = out;
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            super.close();
            this.stream.close();
        }
        catch (IOException ex) {
            throw new XMLStreamException("Failed to close", ex);
        }
    }

    private static OutputStream outputStream(Path path) {
        try {
            return Files.newOutputStream(path, new OpenOption[0]);
        }
        catch (IOException err) {
            throw new UncheckedIOException("Failed to open file stream", err);
        }
    }

    private static XMLStreamWriter xmlStreamWriter(OutputStream stream) {
        try {
            return FACTORY.createXMLStreamWriter(stream, StandardCharsets.UTF_8.name());
        }
        catch (XMLStreamException err) {
            throw new XmlException("Failed to create XML stream", err);
        }
    }
}

