/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlException;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public interface XmlMaid {
    public long clean(Collection<String> var1) throws IOException;

    public static final class ByPkgidAttr
    implements XmlMaid {
        static final String TAG = "package";
        private final Path file;

        public ByPkgidAttr(Path file) {
            this.file = file;
        }

        @Override
        public long clean(Collection<String> ids) throws IOException {
            long res;
            Path tmp = this.file.getParent().resolve(String.format("%s.part", this.file.getFileName().toString()));
            try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);){
                res = new Stream(in, out).clean(ids);
            }
            catch (IOException ex) {
                throw new XmlException(ex);
            }
            Files.move(tmp, this.file, StandardCopyOption.REPLACE_EXISTING);
            return res;
        }

        public static final class Stream
        implements XmlMaid {
            private final InputStream input;
            private final OutputStream out;

            public Stream(InputStream input, OutputStream out) {
                this.input = input;
                this.out = out;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long clean(Collection<String> ids) throws IOException {
                long res;
                try {
                    XMLEventReader reader = new InputFactoryImpl().createXMLEventReader(this.input);
                    XMLEventWriter writer = new OutputFactoryImpl().createXMLEventWriter(this.out);
                    try {
                        res = Stream.process(ids, reader, writer);
                    }
                    finally {
                        writer.close();
                        reader.close();
                    }
                }
                catch (XMLStreamException err) {
                    throw new IOException(err);
                }
                return res;
            }

            private static long process(Collection<String> ids, XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
                boolean valid = true;
                long cnt = 0L;
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(ByPkgidAttr.TAG)) {
                        if (ids.contains(event.asStartElement().getAttributeByName(new QName("pkgid")).getValue())) {
                            valid = false;
                        } else {
                            valid = true;
                            ++cnt;
                        }
                    }
                    if (valid) {
                        writer.add(event);
                    }
                    if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(ByPkgidAttr.TAG)) continue;
                    valid = true;
                }
                return cnt;
            }
        }
    }
}

