/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.asto.ArtipieIOException;
import com.artipie.asto.misc.UncheckedIOConsumer;
import com.artipie.asto.misc.UncheckedIOScalar;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public final class XmlPrimaryChecksums {
    private final InputStream inp;

    public XmlPrimaryChecksums(Path path) {
        this((InputStream)new UncheckedIOScalar(() -> Files.newInputStream(path, new OpenOption[0])).value());
    }

    public XmlPrimaryChecksums(InputStream inp) {
        this.inp = inp;
    }

    public Map<String, String> read() {
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            XMLEventReader reader = new InputFactoryImpl().createXMLEventReader(this.inp);
            String name = "";
            String checksum = "";
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (XmlPrimaryChecksums.isTag(event, "location")) {
                    name = event.asStartElement().getAttributeByName(new QName("href")).getValue();
                }
                if (XmlPrimaryChecksums.isTag(event, "checksum")) {
                    event = reader.nextEvent();
                    checksum = event.asCharacters().getData();
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals("package")) continue;
                res.put(name, checksum);
            }
            reader.close();
        }
        catch (XMLStreamException err) {
            throw new ArtipieIOException((Throwable)err);
        }
        finally {
            Optional.of(this.inp).ifPresent((Consumer<InputStream>)new UncheckedIOConsumer(InputStream::close));
        }
        return res;
    }

    private static boolean isTag(XMLEvent event, String tag) {
        return event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(tag);
    }
}

