/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.misc;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.asto.ext.KeyLastPart;
import com.artipie.asto.ext.PublisherAs;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Supplier;

public final class RpmByDigestCopy {
    private final Storage from;
    private final Key key;
    private final List<String> digests;
    private final Digests algorithm;

    public RpmByDigestCopy(Storage from, Key key, List<String> digests, Digests algorithm) {
        this.from = from;
        this.digests = digests;
        this.key = key;
        this.algorithm = algorithm;
    }

    public RpmByDigestCopy(Storage from, Key key, List<String> digests) {
        this(from, key, digests, Digests.SHA256);
    }

    Completable copy(Storage dest) {
        return SingleInterop.fromFuture((CompletionStage)this.from.list(this.key)).flatMapPublisher(Flowable::fromIterable).filter(item -> item.string().endsWith(".rpm")).flatMapCompletable(rpm -> Completable.fromFuture((Future)((Object)this.from.value(rpm).thenCompose(content -> this.handleRpm(dest, (Key)rpm, (Content)content)))));
    }

    private CompletionStage<Void> handleRpm(Storage dest, Key rpm, Content content) {
        return new PublisherAs(content).bytes().thenCompose(source -> new ContentDigest((Content)new Content.From(source), (Supplier)this.algorithm).hex().thenCompose(hex -> {
            CompletableFuture res = this.digests.contains(hex) ? CompletableFuture.allOf(new CompletableFuture[0]) : dest.save((Key)new Key.From(new KeyLastPart(rpm).get()), (Content)new Content.From(source));
            return res;
        }));
    }
}

