/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.Digest;
import com.artipie.rpm.FileChecksum;
import com.artipie.rpm.pkg.Checksum;
import com.artipie.rpm.pkg.Package;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.redline_rpm.header.AbstractHeader;
import org.redline_rpm.header.Header;

public final class FilePackage
implements Package {

    public static final class EntryHeader
    implements Package.MetaHeader {
        private final Optional<AbstractHeader.Entry<?>> entry;

        public EntryHeader(AbstractHeader.Entry<?> entry) {
            this(Optional.ofNullable(entry));
        }

        EntryHeader(Optional<AbstractHeader.Entry<?>> entry) {
            this.entry = entry;
        }

        @Override
        public String asString(String def) {
            return this.entry.map(e -> ((String[])e.getValues())[0]).orElse(def);
        }

        @Override
        public int asInt(int def) {
            return this.entry.map(e -> {
                int result = e.getValues() instanceof short[] ? ((short[])e.getValues())[0] : ((int[])e.getValues())[0];
                return result;
            }).orElse(def);
        }

        @Override
        public List<String> asStrings() {
            return this.entry.map(e -> Arrays.asList((String[])e.getValues())).orElse(Collections.emptyList());
        }

        @Override
        public int[] asInts() {
            return this.entry.map(e -> {
                int[] result;
                if (e.getValues() instanceof short[]) {
                    short[] sre = (short[])e.getValues();
                    result = new int[sre.length];
                    for (int ind = 0; ind < sre.length; ++ind) {
                        result[ind] = sre[ind];
                    }
                } else {
                    result = (int[])e.getValues();
                }
                return result;
            }).orElseGet(() -> new int[0]);
        }
    }

    public static final class Headers
    implements Package.Meta {
        private final Header hdr;
        private final Path file;
        private final Digest digest;
        private final String location;

        public Headers(Header hdr, Path file, Digest digest, String location) {
            this.hdr = hdr;
            this.file = file;
            this.digest = digest;
            this.location = location;
        }

        public Headers(Header hdr, Path file, Digest digest) {
            this(hdr, file, digest, file.getFileName().toString());
        }

        @Override
        public Package.MetaHeader header(Header.HeaderTag tag) {
            return new EntryHeader(this.hdr.getEntry((AbstractHeader.Tag)tag));
        }

        @Override
        public Checksum checksum() {
            return new FileChecksum(this.file, this.digest);
        }

        @Override
        public long size() throws IOException {
            return Files.size(this.file);
        }

        @Override
        public String href() {
            return this.location;
        }

        @Override
        public int[] range() {
            return new int[]{this.hdr.getStartPos(), this.hdr.getEndPos()};
        }
    }
}

