/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.ArtipieException;
import com.artipie.rpm.pkg.Package;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.redline_rpm.header.Header;

public final class HeaderTags {
    private final Package.Meta meta;

    public HeaderTags(Package.Meta meta) {
        this.meta = meta;
    }

    public String name() {
        return this.meta.header(Header.HeaderTag.NAME).asString("");
    }

    public String arch() {
        return this.meta.header(Header.HeaderTag.ARCH).asString("");
    }

    public int epoch() {
        return this.meta.header(Header.HeaderTag.EPOCH).asInt(0);
    }

    public String version() {
        return this.meta.header(Header.HeaderTag.VERSION).asString("");
    }

    public String release() {
        return this.meta.header(Header.HeaderTag.RELEASE).asString("");
    }

    public String summary() {
        return this.meta.header(Header.HeaderTag.SUMMARY).asString("");
    }

    public String description() {
        return this.meta.header(Header.HeaderTag.DESCRIPTION).asString("");
    }

    public String packager() {
        return this.meta.header(Header.HeaderTag.PACKAGER).asString("");
    }

    public String url() {
        return this.meta.header(Header.HeaderTag.URL).asString("");
    }

    public int fileTimes() {
        return this.meta.header(Header.HeaderTag.FILEMTIMES).asInt(0);
    }

    public int buildTime() {
        return this.meta.header(Header.HeaderTag.BUILDTIME).asInt(0);
    }

    public int installedSize() {
        return this.meta.header(Header.HeaderTag.SIZE).asInt(0);
    }

    public int archiveSize() {
        return this.meta.header(Header.HeaderTag.ARCHIVESIZE).asInt(0);
    }

    public String license() {
        return this.meta.header(Header.HeaderTag.LICENSE).asString("");
    }

    public String vendor() {
        return this.meta.header(Header.HeaderTag.VENDOR).asString("");
    }

    public String group() {
        return this.meta.header(Header.HeaderTag.GROUP).asString("");
    }

    public String buildHost() {
        return this.meta.header(Header.HeaderTag.BUILDHOST).asString("");
    }

    public String sourceRmp() {
        return this.meta.header(Header.HeaderTag.SOURCERPM).asString("");
    }

    public List<String> providesNames() {
        return this.meta.header(Header.HeaderTag.PROVIDENAME).asStrings();
    }

    public List<Version> providesVer() {
        return this.meta.header(Header.HeaderTag.PROVIDEVERSION).asStrings().stream().map(Version::new).collect(Collectors.toList());
    }

    public List<Optional<String>> providesFlags() {
        int[] array = this.meta.header(Header.HeaderTag.PROVIDEFLAGS).asInts();
        return Arrays.stream(array).mapToObj(Flags::find).collect(Collectors.toList());
    }

    public List<String> requires() {
        return this.meta.header(Header.HeaderTag.REQUIRENAME).asStrings();
    }

    public List<Version> requiresVer() {
        return this.meta.header(Header.HeaderTag.REQUIREVERSION).asStrings().stream().map(Version::new).collect(Collectors.toList());
    }

    public List<Optional<String>> requireFlags() {
        return this.requireFlagsInts().stream().map(flag -> flag & 0xF).map(Flags::find).collect(Collectors.toList());
    }

    public List<String> obsoletes() {
        return this.meta.header(Header.HeaderTag.OBSOLETENAME).asStrings();
    }

    public List<Version> obsoletesVer() {
        return this.meta.header(Header.HeaderTag.OBSOLETEVERSION).asStrings().stream().map(Version::new).collect(Collectors.toList());
    }

    public List<Optional<String>> obsoletesFlags() {
        return Arrays.stream(this.meta.header(Header.HeaderTag.OBSOLETEFLAGS).asInts()).map(flag -> flag & 0xF).mapToObj(Flags::find).collect(Collectors.toList());
    }

    public List<String> conflicts() {
        return this.meta.header(Header.HeaderTag.CONFLICTNAME).asStrings();
    }

    public List<Version> conflictsVer() {
        return this.meta.header(Header.HeaderTag.CONFLICTVERSION).asStrings().stream().map(Version::new).collect(Collectors.toList());
    }

    public List<Optional<String>> conflictsFlags() {
        return Arrays.stream(this.meta.header(Header.HeaderTag.CONFLICTFLAGS).asInts()).map(flag -> flag & 0xF).mapToObj(Flags::find).collect(Collectors.toList());
    }

    public List<Integer> requireFlagsInts() {
        int[] array = this.meta.header(Header.HeaderTag.REQUIREFLAGS).asInts();
        return Arrays.stream(array).boxed().collect(Collectors.toList());
    }

    public List<String> baseNames() {
        return this.meta.header(Header.HeaderTag.BASENAMES).asStrings();
    }

    public List<String> dirNames() {
        return this.meta.header(Header.HeaderTag.DIRNAMES).asStrings();
    }

    public int[] dirIndexes() {
        return this.meta.header(Header.HeaderTag.DIRINDEXES).asInts();
    }

    public int[] fileModes() {
        return this.meta.header(Header.HeaderTag.FILEMODES).asInts();
    }

    public int[] fileFlags() {
        return this.meta.header(Header.HeaderTag.FILEFLAGS).asInts();
    }

    public List<String> changelog() {
        return this.meta.header(Header.HeaderTag.CHANGELOG).asStrings();
    }

    public static enum Flags {
        EQUAL(8, "EQ"),
        GREATER(4, "GT"),
        LESS(2, "LT"),
        GREATER_OR_EQUAL(12, "GE"),
        LESS_OR_EQUAL(10, "LE");

        private final int icode;
        private final String name;

        private Flags(int icode, String name) {
            this.icode = icode;
            this.name = name;
        }

        public String notation() {
            return this.name;
        }

        public int code() {
            return this.icode;
        }

        static Optional<String> find(int code) {
            return Arrays.stream(Flags.values()).filter(item -> code == item.icode).findFirst().map(Flags::notation);
        }
    }

    public static final class Version
    implements Comparable<Version> {
        private static final Pattern PTRN = Pattern.compile("((?<epoch>\\d+):)?(?<ver>[^/-]+|^(?!.))(-(?<rel>[^/]*))?");
        private final String val;

        public Version(String val) {
            this.val = val;
        }

        public String ver() {
            return this.part("ver").orElseThrow(() -> new ArtipieException((Throwable)new IllegalArgumentException("Invalid version value")));
        }

        public Optional<String> rel() {
            return this.part("rel");
        }

        public String epoch() {
            return this.part("epoch").orElse("0");
        }

        public String toString() {
            return this.val;
        }

        @Override
        public int compareTo(Version another) {
            int res;
            if (this.val.equals(another.val)) {
                res = 0;
            } else {
                res = Integer.compare(Integer.parseInt(this.epoch()), Integer.parseInt(another.epoch()));
                if (res == 0) {
                    res = new ComparableVersion(this.rel().map(rel -> String.format("%s-%s", this.ver(), rel)).orElse(this.ver())).compareTo(new ComparableVersion(another.rel().map(rel -> String.format("%s-%s", another.ver(), rel)).orElse(another.ver())));
                }
            }
            return res;
        }

        private Optional<String> part(String name) {
            Matcher matcher = PTRN.matcher(this.val);
            if (matcher.matches()) {
                return Optional.ofNullable(matcher.group(name));
            }
            throw new ArtipieException((Throwable)new IllegalArgumentException("Provided version is invalid"));
        }
    }
}

