/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.rpm.Digest;
import com.artipie.rpm.FileChecksum;
import com.artipie.rpm.Repository;
import com.artipie.rpm.misc.UncheckedConsumer;
import com.artipie.rpm.pkg.FilePackage;
import com.artipie.rpm.pkg.InvalidPackageException;
import com.artipie.rpm.pkg.Metadata;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import com.artipie.rpm.pkg.Repodata;
import com.jcabi.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;

public final class ModifiableRepository
implements PackageOutput {
    private final Repository origin;
    private final List<String> existing;
    private final List<Metadata> metadata;
    private final Digest digest;

    public ModifiableRepository(List<String> existing, List<Metadata> metadata, Digest digest) {
        this.existing = existing;
        this.metadata = metadata;
        this.digest = digest;
        this.origin = new Repository(metadata, digest);
    }

    public ModifiableRepository update(FilePackage pkg) throws IOException {
        String hex = new FileChecksum(pkg.path(), this.digest).hex();
        if (!this.existing.remove(hex)) {
            try {
                this.origin.update(pkg.parsed());
            }
            catch (InvalidPackageException ex) {
                Logger.warn((Object)this, (String)"Failed parsing '%s': %[exception]s", (Object[])new Object[]{pkg.path(), ex});
            }
        }
        return this;
    }

    public ModifiableRepository clear() {
        ((Stream)this.metadata.stream().parallel()).forEach(new UncheckedConsumer(meta -> meta.brush(this.existing)));
        return this;
    }

    @Override
    public void accept(Package.Meta meta) throws IOException {
        this.origin.accept(meta);
    }

    @Override
    public void close() {
        ((Stream)this.metadata.stream().parallel()).forEach(new UncheckedConsumer(Closeable::close));
    }

    public List<Path> save(Repodata repodata) throws IOException {
        return this.origin.save(repodata);
    }
}

