/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.Rpm;
import com.google.common.base.Splitter;
import com.google.common.collect.Streams;
import hu.akarnokd.rxjava2.interop.CompletableInterop;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

final class RpmUpload
implements Slice {
    private final Storage asto;
    private final Rpm rpm;

    RpmUpload(Storage storage, RepoConfig config) {
        this.asto = storage;
        this.rpm = new Rpm(storage, config);
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Request request = new Request(line);
        Key key = request.file();
        CompletableFuture conflict = request.override() ? CompletableFuture.completedFuture(false) : this.asto.exists(key);
        return new AsyncResponse(conflict.thenApply(conflicts -> {
            Object response = conflicts != false ? new RsWithStatus(RsStatus.CONFLICT) : new AsyncResponse(CompletableInterop.fromFuture((CompletionStage)this.asto.save(key, (Content)new Content.From(body))).andThen((CompletableSource)Completable.defer(() -> {
                Completable result = request.skipUpdate() ? Completable.complete() : this.rpm.batchUpdate(Key.ROOT);
                return result;
            })).andThen((SingleSource)Single.just((Object)new RsWithStatus(RsStatus.ACCEPTED))));
            return response;
        }));
    }

    static final class Request {
        public static final Pattern PTRN = Pattern.compile("^/(?<rpm>.*\\.rpm)");
        private final String line;

        Request(String line) {
            this.line = line;
        }

        public Key file() {
            return new Key.From(this.path().group("rpm"));
        }

        public boolean override() {
            return this.hasParamValue("override=true");
        }

        public boolean skipUpdate() {
            return this.hasParamValue("skip_update=true");
        }

        private Matcher path() {
            String path = new RequestLineFrom(this.line).uri().getPath();
            Matcher matcher = PTRN.matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException(String.format("Unexpected path: %s", path));
            }
            return matcher;
        }

        private boolean hasParamValue(String param) {
            return Optional.ofNullable(new RequestLineFrom(this.line).uri().getQuery()).map(query -> Streams.stream((Iterable)Splitter.on((String)"&").split((CharSequence)query))).orElse(Stream.empty()).anyMatch(part -> part.equals(param));
        }
    }
}

