/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlFile;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlPackagesFile;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public final class XmlFilelists
implements Closeable {
    private final XmlFile xml;
    private final XmlPackagesFile packages;

    public XmlFilelists(Path file) {
        this(new XmlFile(file));
    }

    public XmlFilelists(XmlFile xml) {
        this.xml = xml;
        this.packages = new XmlPackagesFile(xml, XmlPackage.FILELISTS);
    }

    public XmlFilelists startPackages() throws XMLStreamException {
        this.packages.startPackages();
        return this;
    }

    public Package startPackage(String name, String arch, String checksum) throws XMLStreamException {
        this.xml.writeStartElement("package");
        this.xml.writeAttribute("pkgid", checksum);
        this.xml.writeAttribute("name", name);
        this.xml.writeAttribute("arch", arch);
        return new Package(this, this.xml);
    }

    @Override
    public void close() throws IOException {
        this.packages.close();
    }

    public static final class Package {
        private final XmlFilelists filelists;
        private final XmlFile xml;

        Package(XmlFilelists filelists, XmlFile xml) {
            this.filelists = filelists;
            this.xml = xml;
        }

        public Package version(int epoch, String ver, String rel) throws XMLStreamException {
            this.xml.writeEmptyElement("version");
            this.xml.writeAttribute("epoch", String.valueOf(epoch));
            this.xml.writeAttribute("ver", ver);
            this.xml.writeAttribute("rel", rel);
            return this;
        }

        public Package files(String[] files, String[] dirs, int[] did) throws XMLStreamException {
            Set dirset = Arrays.stream(dirs).collect(Collectors.toSet());
            for (int idx = 0; idx < files.length; ++idx) {
                String fle = files[idx];
                if (fle.isEmpty() || fle.charAt(0) == '.') continue;
                String path = String.format("%s%s", dirs[did[idx]], fle);
                this.xml.writeStartElement("file");
                if (dirset.contains(String.format("%s/", path))) {
                    this.xml.writeAttribute("type", "dir");
                }
                this.xml.writeCharacters(path);
                this.xml.writeEndElement();
            }
            return this;
        }

        public XmlFilelists close() throws XMLStreamException {
            this.xml.writeEndElement();
            return this.filelists;
        }
    }
}

