/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlFile;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.meta.XmlPackagesFile;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public final class XmlPrimary
implements Closeable {
    private static final String NAMESPACE = XmlPackage.PRIMARY.xmlNamespaces().get("rpm");
    private final XmlFile xml;
    private final XmlPackagesFile packages;

    public XmlPrimary(Path path) {
        this(new XmlFile(path));
    }

    public XmlPrimary(XmlFile xml) {
        this.xml = xml;
        this.packages = new XmlPackagesFile(xml, XmlPackage.PRIMARY);
    }

    public XmlPrimary startPackages() throws XMLStreamException {
        this.packages.startPackages();
        return this;
    }

    public Package startPackage() throws XMLStreamException {
        this.xml.writeStartElement("package");
        this.xml.writeAttribute("type", "rpm");
        return new Package(this.xml, this);
    }

    @Override
    public void close() throws IOException {
        this.packages.close();
    }

    public static final class Format {
        private final XmlFile xml;
        private final Package pkg;

        Format(XmlFile xml, Package pkg) {
            this.xml = xml;
            this.pkg = pkg;
        }

        public Format license(String license) throws XMLStreamException {
            return this.writeElem("license", license);
        }

        public Format vendor(String vendor) throws XMLStreamException {
            return this.writeElem("vendor", vendor);
        }

        public Format group(String group) throws XMLStreamException {
            return this.writeElem("group", group);
        }

        public Format buildHost(String host) throws XMLStreamException {
            return this.writeElem("buildhost", host);
        }

        public Format sourceRpm(String source) throws XMLStreamException {
            return this.writeElem("sourcerpm", source);
        }

        public Format headerRange(int start, int end) throws XMLStreamException {
            this.xml.writeEmptyElement(NAMESPACE, "header-range");
            this.xml.writeAttribute("start", String.valueOf(start));
            this.xml.writeAttribute("end", String.valueOf(end));
            return this;
        }

        public Format provides(List<String> names, List<String> versions) throws XMLStreamException {
            this.xml.writeStartElement(NAMESPACE, "provides");
            for (int ind = 0; ind < names.size(); ++ind) {
                this.xml.writeStartElement(NAMESPACE, "entry");
                this.xml.writeAttribute("name", names.get(ind));
                if (ind < versions.size()) {
                    this.xml.writeAttribute("ver", versions.get(ind));
                }
                this.xml.writeEndElement();
            }
            this.xml.writeEndElement();
            return this;
        }

        public Format requires(List<String> requires) throws XMLStreamException {
            this.xml.writeStartElement(NAMESPACE, "requires");
            List filtered = requires.stream().filter(nme -> !nme.startsWith("rpmlib(")).collect(Collectors.toList());
            for (String name : filtered) {
                this.xml.writeStartElement(NAMESPACE, "entry");
                this.xml.writeAttribute("name", name);
                this.xml.writeEndElement();
            }
            this.xml.writeEndElement();
            return this;
        }

        public Package close() throws XMLStreamException {
            this.xml.writeEndElement();
            return this.pkg;
        }

        private Format writeElem(String name, String value) throws XMLStreamException {
            this.xml.writeStartElement(NAMESPACE, name);
            this.xml.writeCharacters(value);
            this.xml.writeEndElement();
            return this;
        }
    }

    public static final class Package {
        private final XmlFile xml;
        private final XmlPrimary primary;

        public Package(XmlFile xml, XmlPrimary primary) {
            this.xml = xml;
            this.primary = primary;
        }

        public Package name(String name) throws XMLStreamException {
            this.xml.writeStartElement("name");
            this.xml.writeCharacters(name);
            this.xml.writeEndElement();
            return this;
        }

        public Package arch(String arch) throws XMLStreamException {
            this.xml.writeStartElement("arch");
            this.xml.writeCharacters(arch);
            this.xml.writeEndElement();
            return this;
        }

        public Package version(int epoch, String ver, String rel) throws XMLStreamException {
            this.xml.writeEmptyElement("version");
            this.xml.writeAttribute("epoch", String.valueOf(epoch));
            this.xml.writeAttribute("ver", ver);
            this.xml.writeAttribute("rel", rel);
            return this;
        }

        public Package checksum(String type, String id, String sum) throws XMLStreamException {
            this.xml.writeStartElement("checksum");
            this.xml.writeAttribute("type", type);
            this.xml.writeAttribute("pkgid", id);
            this.xml.writeCharacters(sum);
            this.xml.writeEndElement();
            return this;
        }

        public Package summary(String text) throws XMLStreamException {
            this.xml.writeStartElement("summary");
            this.xml.writeCharacters(text);
            this.xml.writeEndElement();
            return this;
        }

        public Package description(String text) throws XMLStreamException {
            this.xml.writeStartElement("description");
            this.xml.writeCharacters(text);
            this.xml.writeEndElement();
            return this;
        }

        public Package packager(String name) throws XMLStreamException {
            this.xml.writeStartElement("packager");
            this.xml.writeCharacters(name);
            this.xml.writeEndElement();
            return this;
        }

        public Package url(String url) throws XMLStreamException {
            this.xml.writeStartElement("url");
            this.xml.writeCharacters(url);
            this.xml.writeEndElement();
            return this;
        }

        public Package time(int file, int build) throws XMLStreamException {
            this.xml.writeEmptyElement("time");
            this.xml.writeAttribute("file", String.valueOf(file));
            this.xml.writeAttribute("build", String.valueOf(build));
            return this;
        }

        public Package size(long pkg, int installed, int archive) throws XMLStreamException {
            this.xml.writeEmptyElement("size");
            this.xml.writeAttribute("package", String.valueOf(pkg));
            this.xml.writeAttribute("installed", String.valueOf(installed));
            this.xml.writeAttribute("archive", String.valueOf(archive));
            return this;
        }

        public Package location(String href) throws XMLStreamException {
            this.xml.writeEmptyElement("location");
            this.xml.writeAttribute("href", href);
            return this;
        }

        public Package files(String[] files, String[] dirs, int[] did) throws XMLStreamException {
            Set dirset = Arrays.stream(dirs).collect(Collectors.toSet());
            for (int idx = 0; idx < files.length; ++idx) {
                String fle = files[idx];
                if (fle.isEmpty() || fle.charAt(0) == '.') continue;
                String path = String.format("%s%s", dirs[did[idx]], fle);
                this.xml.writeStartElement("file");
                if (dirset.contains(String.format("%s/", path))) {
                    this.xml.writeAttribute("type", "dir");
                }
                this.xml.writeCharacters(path);
                this.xml.writeEndElement();
            }
            return this;
        }

        public Format startFormat() throws XMLStreamException {
            this.xml.writeStartElement("format");
            return new Format(this.xml, this);
        }

        public XmlPrimary close() throws XMLStreamException {
            this.xml.writeEndElement();
            return this.primary;
        }
    }
}

