/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlMaid;
import com.artipie.rpm.meta.XmlPackage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public final class XmlPrimaryMaid
implements XmlMaid {
    private final Path file;

    public XmlPrimaryMaid(Path file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clean(List<String> checksums) throws IOException {
        long res;
        Path tmp = this.file.getParent().resolve(String.format("%s.part", this.file.getFileName().toString()));
        try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);
             OutputStream out = Files.newOutputStream(tmp, new OpenOption[0]);){
            XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(in);
            XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(out);
            try {
                XMLEventFactory events = XMLEventFactory.newFactory();
                writer.add(reader.nextEvent());
                writer.add(events.createSpace("\n"));
                writer.add(reader.nextEvent());
                writer.add(reader.nextEvent());
                res = XmlPrimaryMaid.processPackages(checksums, reader, writer);
                writer.add(events.createSpace("\n"));
                writer.add(events.createEndElement(new QName(XmlPackage.PRIMARY.tag()), Collections.emptyIterator()));
            }
            finally {
                writer.close();
                reader.close();
            }
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
        Files.move(tmp, this.file, StandardCopyOption.REPLACE_EXISTING);
        return res;
    }

    private static long processPackages(List<String> checksums, XMLEventReader reader, XMLEventWriter writer) throws XMLStreamException {
        ArrayList<XMLEvent> pckg = new ArrayList<XMLEvent>(10);
        boolean valid = true;
        long cnt = 0L;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (XmlPrimaryMaid.isTag(event, "package")) {
                pckg.clear();
            }
            pckg.add(event);
            if (XmlPrimaryMaid.isTag(event, "checksum")) {
                event = reader.nextEvent();
                pckg.add(event);
                boolean bl = valid = event.isCharacters() && !checksums.contains(event.asCharacters().getData());
            }
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals("package") || !valid) continue;
            ++cnt;
            for (XMLEvent item : pckg) {
                writer.add(item);
            }
        }
        return cnt;
    }

    private static boolean isTag(XMLEvent event, String tag) {
        return event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(tag);
    }
}

