/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import com.artipie.rpm.meta.XmlFile;
import com.artipie.rpm.pkg.Checksum;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class XmlRepomd
implements Closeable {
    private final XmlFile xml;
    private final Path path;

    public XmlRepomd(Path path) {
        this(path, new XmlFile(path));
    }

    public XmlRepomd(Path path, XmlFile xml) {
        this.xml = xml;
        this.path = path;
    }

    public void begin(long timestamp) throws IOException {
        try {
            this.xml.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
            this.xml.writeStartElement("repomd");
            this.xml.writeDefaultNamespace("http://linux.duke.edu/metadata/repo");
            this.xml.writeStartElement("revision");
            this.xml.writeCharacters(String.valueOf(timestamp));
            this.xml.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IOException("Failed to start repomd", ex);
        }
    }

    public Data beginData(String type) throws XMLStreamException {
        this.xml.writeStartElement("data");
        this.xml.writeAttribute("type", type);
        return new Data(this.xml);
    }

    public Path file() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        try {
            this.xml.writeEndElement();
            this.xml.close();
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to close", err);
        }
    }

    public static final class Data
    implements Closeable {
        private final XMLStreamWriter xml;

        private Data(XMLStreamWriter xml) {
            this.xml = xml;
        }

        public void gzipChecksum(Checksum checksum) throws XMLStreamException, IOException {
            this.xml.writeStartElement("checksum");
            this.xml.writeAttribute("type", checksum.digest().type());
            this.xml.writeCharacters(checksum.hex());
            this.xml.writeEndElement();
        }

        public void openChecksum(Checksum checksum) throws XMLStreamException, IOException {
            this.xml.writeStartElement("open-checksum");
            this.xml.writeAttribute("type", checksum.digest().type());
            this.xml.writeCharacters(checksum.hex());
            this.xml.writeEndElement();
        }

        public void location(String href) throws XMLStreamException {
            this.xml.writeEmptyElement("location");
            this.xml.writeAttribute("href", href);
        }

        public void timestamp(long sec) throws XMLStreamException {
            this.xml.writeStartElement("timestamp");
            this.xml.writeCharacters(Long.toString(sec));
            this.xml.writeEndElement();
        }

        public void gzipSize(long size) throws XMLStreamException {
            this.xml.writeStartElement("size");
            this.xml.writeCharacters(Long.toString(size));
            this.xml.writeEndElement();
        }

        public void openSize(long size) throws XMLStreamException {
            this.xml.writeStartElement("open-size");
            this.xml.writeCharacters(Long.toString(size));
            this.xml.writeEndElement();
        }

        @Override
        public void close() throws IOException {
            try {
                this.xml.writeEndElement();
            }
            catch (XMLStreamException err) {
                throw new IOException("Failed to close", err);
            }
        }
    }
}

