/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.meta.XmlMaid;
import com.artipie.rpm.meta.XmlOthers;
import com.artipie.rpm.meta.XmlPackage;
import com.artipie.rpm.pkg.HeaderTags;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import javax.xml.stream.XMLStreamException;

public final class OthersOutput
implements PackageOutput.FileOutput {
    private final Path path;
    private final Path tmp;
    private final XmlOthers xml;

    public OthersOutput(Path file) {
        this.path = file;
        this.tmp = file.getParent().resolve(String.format("%s.part", file.getFileName().toString()));
        this.xml = new XmlOthers(this.tmp);
    }

    @Override
    public OthersOutput start() throws IOException {
        try {
            this.xml.startPackages();
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to start packages", err);
        }
        return this;
    }

    @Override
    public void accept(Package.Meta meta) throws IOException {
        HeaderTags tags = new HeaderTags(meta);
        try {
            this.xml.addPackage(tags.name(), tags.arch(), meta.checksum().hex()).version(tags.epoch(), tags.version(), tags.release()).changelog(tags.changelog()).close();
        }
        catch (XMLStreamException err) {
            throw new IOException("Failed to add package", err);
        }
    }

    @Override
    public void close() throws IOException {
        this.xml.close();
        Files.move(this.tmp, this.path, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public Path file() {
        return this.path;
    }

    @Override
    public XmlMaid maid() {
        return new XmlMaid.ByPkgidAttr(this.path);
    }

    @Override
    public String tag() {
        return XmlPackage.OTHER.tag();
    }
}

