/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.pkg;

import com.artipie.rpm.meta.XmlMaid;
import com.artipie.rpm.misc.UncheckedConsumer;
import com.artipie.rpm.pkg.Metadata;
import com.artipie.rpm.pkg.Package;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.StreamSupport;

public interface PackageOutput
extends Closeable {
    public void accept(Package.Meta var1) throws IOException;

    public static final class Multiple
    implements PackageOutput {
        private final Iterable<? extends Metadata> list;

        public Multiple(Metadata ... outs) {
            this(Arrays.asList(outs));
        }

        public Multiple(Iterable<? extends Metadata> outs) {
            this.list = outs;
        }

        @Override
        public void accept(Package.Meta meta) {
            StreamSupport.stream(this.list.spliterator(), true).forEach(new UncheckedConsumer(out -> out.accept(meta)));
        }

        @Override
        public void close() throws IOException {
            LinkedList<IOException> errors = new LinkedList<IOException>();
            for (Metadata metadata : this.list) {
                try {
                    metadata.close();
                    metadata.brush(Collections.emptyList());
                }
                catch (IOException err) {
                    errors.add(err);
                }
            }
            if (!errors.isEmpty()) {
                IOException exc = new IOException("Couldn't close underlying outputs");
                errors.forEach(exc::addSuppressed);
                throw exc;
            }
        }
    }

    public static interface FileOutput
    extends PackageOutput {
        public Path file();

        public XmlMaid maid();

        public String tag();

        public FileOutput start() throws IOException;

        public static final class Fake
        implements FileOutput {
            private final Path file;
            private boolean accepted;

            public Fake(Path file) {
                this.file = file;
                this.accepted = false;
            }

            @Override
            public Fake start() throws IOException {
                Files.write(this.file, Arrays.asList("content"), new OpenOption[0]);
                return this;
            }

            @Override
            public void accept(Package.Meta meta) {
                this.accepted = true;
            }

            @Override
            public void close() {
            }

            @Override
            public Path file() {
                return this.file;
            }

            @Override
            public XmlMaid maid() {
                return null;
            }

            @Override
            public String tag() {
                return "fake";
            }

            public boolean isAccepted() {
                return this.accepted;
            }
        }
    }
}

