/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.fs.FileStorage;
import com.artipie.rpm.CliArguments;
import com.artipie.rpm.Digest;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.RepoConfig;
import com.artipie.rpm.Rpm;
import java.nio.file.Path;

public final class Cli {
    private final Rpm rpm;

    private Cli(Rpm rpm) {
        this.rpm = rpm;
    }

    public static void main(String ... args) {
        CliArguments cliargs = new CliArguments(args);
        RepoConfig cnfg = cliargs.config();
        NamingPolicy naming = cnfg.naming();
        System.out.printf("RPM naming-policy=%s\n", naming);
        Digest digest = cnfg.digest();
        System.out.printf("RPM digest=%s\n", new Object[]{digest});
        boolean filelists = cnfg.filelists();
        System.out.printf("RPM file-lists=%s\n", filelists);
        Path repository = cliargs.repository();
        System.out.printf("RPM repository=%s\n", repository);
        try {
            new Cli(new Rpm((Storage)new FileStorage(repository), naming, digest, filelists)).run();
        }
        catch (Exception err) {
            System.err.printf("RPM failed: %s\n", err.getLocalizedMessage());
            err.printStackTrace(System.err);
        }
    }

    private void run() {
        this.rpm.batchUpdate(Key.ROOT).blockingAwait();
    }
}

