/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.artipie.rpm.Digest;
import com.artipie.rpm.NamingPolicy;
import com.artipie.rpm.RpmOptions;
import com.artipie.rpm.StandardNamingPolicy;
import java.util.Locale;
import java.util.Optional;

public interface RepoConfig {
    public Digest digest();

    public NamingPolicy naming();

    public boolean filelists();

    public static final class Simple
    implements RepoConfig {
        private final Digest dgst;
        private final NamingPolicy npolicy;
        private final boolean filelist;

        public Simple(Digest dgst, NamingPolicy npolicy, boolean filelist) {
            this.dgst = dgst;
            this.npolicy = npolicy;
            this.filelist = filelist;
        }

        public Simple() {
            this(Digest.SHA256, StandardNamingPolicy.PLAIN, false);
        }

        @Override
        public Digest digest() {
            return this.dgst;
        }

        @Override
        public NamingPolicy naming() {
            return this.npolicy;
        }

        @Override
        public boolean filelists() {
            return this.filelist;
        }
    }

    public static final class FromYaml
    implements RepoConfig {
        private final YamlMapping yaml;

        public FromYaml(YamlMapping yaml) {
            this.yaml = yaml;
        }

        public FromYaml(Optional<YamlMapping> yaml) {
            this(yaml.orElse(Yaml.createYamlMappingBuilder().build()));
        }

        @Override
        public Digest digest() {
            return Optional.ofNullable(this.yaml.string(RpmOptions.DIGEST.optionName())).map(dgst -> Digest.valueOf(dgst.toUpperCase(Locale.US))).orElse(Digest.SHA256);
        }

        @Override
        public NamingPolicy naming() {
            return Optional.ofNullable(this.yaml.string(RpmOptions.NAMING_POLICY.optionName())).map(naming -> StandardNamingPolicy.valueOf(naming.toUpperCase(Locale.US))).orElse(StandardNamingPolicy.SHA256);
        }

        @Override
        public boolean filelists() {
            return !Boolean.FALSE.toString().equals(this.yaml.string(RpmOptions.FILELISTS.optionName()));
        }
    }
}

