/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm;

import com.artipie.rpm.Digest;
import com.artipie.rpm.meta.XmlRepomd;
import com.artipie.rpm.misc.UncheckedFunc;
import com.artipie.rpm.pkg.Metadata;
import com.artipie.rpm.pkg.Package;
import com.artipie.rpm.pkg.PackageOutput;
import com.artipie.rpm.pkg.Repodata;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

final class Repository
implements PackageOutput {
    private final List<Metadata> metadata;
    private final Digest digest;

    Repository(List<Metadata> files, Digest digest) {
        this.metadata = files;
        this.digest = digest;
    }

    public Repository update(Package pkg) throws IOException {
        pkg.save(this, this.digest);
        return this;
    }

    @Override
    public void accept(Package.Meta meta) throws IOException {
        new PackageOutput.Multiple(this.metadata).accept(meta);
    }

    @Override
    public void close() throws IOException {
        new PackageOutput.Multiple(this.metadata).close();
        Logger.info((Object)this, (String)"repository closed");
    }

    public List<Path> save(Repodata repodata) throws IOException {
        try (XmlRepomd repomd = repodata.createRepomd();){
            repomd.begin(System.currentTimeMillis() / 1000L);
            List<Path> outs = this.metadata.stream().map(new UncheckedFunc(meta -> meta.save(repodata, this.digest, repomd))).collect(Collectors.toList());
            outs.add(repomd.file());
            List<Path> list = outs;
            return list;
        }
    }
}

