/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.rpm.meta;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackagesCount {
    private static final Pattern ATTR = Pattern.compile("packages=\"(\\d+)\"");
    private static final int MAX_LINES = 10;
    private final Path path;

    public PackagesCount(Path path) {
        this.path = path;
    }

    public int value() throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(this.path);){
            String line;
            OptionalInt result = OptionalInt.empty();
            for (int lines = 0; lines < 10 && (line = reader.readLine()) != null; ++lines) {
                Matcher matcher = ATTR.matcher(line);
                if (!matcher.find()) continue;
                result = OptionalInt.of(Integer.parseInt(matcher.group(1)));
                break;
            }
            int n = result.orElseThrow(() -> new IllegalArgumentException("Failed to find packages attribute"));
            return n;
        }
    }
}

